package com.icetech.sdk.request.p2c.pay;

import com.icetech.sdk.request.BaseRequest;
import com.icetech.sdk.response.p2c.pay.P2cNotifyPayResponse;

/**
 * The type P 2 c notify pay request.
 */
public class P2cNotifyPayRequest extends BaseRequest<P2cNotifyPayResponse> {
    /**
     * 停车场编号
     */
    private String parkCode;

    /**
     * 车牌号
     */
    private String plateNum;

    /**
     * 订单号
     */
    private String orderNum;

    /**
     * 交易流水号，如果是云平台交易流水号，此值从拉取费用接口获取
     */
    private String tradeNo;

    /**
     * 是否为云平台流水号，1：是，0：否，不是云平台流水号，即第三方流水号，要确保全局唯一性
     */
    private Integer isCloudTradeNo;

    /**
     * 支付渠道
     */
    private Integer payChannel;

    /**
     * 支付方式
     */
    private Integer payWay;

    /**
     * 需支付金额 ，与拉取费用接口返回的needPayPrice相同
     */
    private Double needPayPrice;

    /**
     * 实际支付金额，needPayPrice = actualPayPrice + actualDiscount
     */
    private Double actualPayPrice;

    /**
     * 实际优惠金额，needPayPrice = actualPayPrice + actualDiscount
     */
    private Double actualDiscount;
    
    /**
     * 拓展三方自有支付
     */
    private String payTerminal;

    /**
     * 支付场景，1：场内支付（默认），2：出口支付，如果是出口缴费，云平台会放行此车辆
     */
    private Integer payScene;

    /**
     * 通道编号，出口支付时必传
     */
    private String channelId;
    /**
     * 支付成功时间
     */
    private Long payTime;

    /**
     * Gets park code.
     *
     * @return the park code
     */
    public String getParkCode() {
        return parkCode;
    }

    /**
     * Sets park code.
     *
     * @param parkCode the park code
     */
    public void setParkCode(String parkCode) {
        this.parkCode = parkCode;
    }

    /**
     * Gets plate num.
     *
     * @return the plate num
     */
    public String getPlateNum() {
        return plateNum;
    }

    /**
     * Sets plate num.
     *
     * @param plateNum the plate num
     */
    public void setPlateNum(String plateNum) {
        this.plateNum = plateNum;
    }

    /**
     * Gets order num.
     *
     * @return the order num
     */
    public String getOrderNum() {
        return orderNum;
    }

    /**
     * Sets order num.
     *
     * @param orderNum the order num
     */
    public void setOrderNum(String orderNum) {
        this.orderNum = orderNum;
    }

    /**
     * Gets trade no.
     *
     * @return the trade no
     */
    public String getTradeNo() {
        return tradeNo;
    }

    /**
     * Sets trade no.
     *
     * @param tradeNo the trade no
     */
    public void setTradeNo(String tradeNo) {
        this.tradeNo = tradeNo;
    }

    /**
     * Gets is cloud trade no.
     *
     * @return the is cloud trade no
     */
    public Integer getIsCloudTradeNo() {
        return isCloudTradeNo;
    }

    /**
     * Sets is cloud trade no.
     *
     * @param isCloudTradeNo the is cloud trade no
     */
    public void setIsCloudTradeNo(Integer isCloudTradeNo) {
        this.isCloudTradeNo = isCloudTradeNo;
    }

    /**
     * Gets pay channel.
     *
     * @return the pay channel
     */
    public Integer getPayChannel() {
        return payChannel;
    }

    /**
     * Sets pay channel.
     *
     * @param payChannel the pay channel
     */
    public void setPayChannel(Integer payChannel) {
        this.payChannel = payChannel;
    }

    /**
     * Gets pay way.
     *
     * @return the pay way
     */
    public Integer getPayWay() {
        return payWay;
    }

    /**
     * Sets pay way.
     *
     * @param payWay the pay way
     */
    public void setPayWay(Integer payWay) {
        this.payWay = payWay;
    }

    /**
     * Gets need pay price.
     *
     * @return the need pay price
     */
    public Double getNeedPayPrice() {
        return needPayPrice;
    }

    /**
     * Sets need pay price.
     *
     * @param needPayPrice the need pay price
     */
    public void setNeedPayPrice(Double needPayPrice) {
        this.needPayPrice = needPayPrice;
    }

    /**
     * Gets actual pay price.
     *
     * @return the actual pay price
     */
    public Double getActualPayPrice() {
        return actualPayPrice;
    }

    /**
     * Sets actual pay price.
     *
     * @param actualPayPrice the actual pay price
     */
    public void setActualPayPrice(Double actualPayPrice) {
        this.actualPayPrice = actualPayPrice;
    }

    /**
     * Gets actual discount.
     *
     * @return the actual discount
     */
    public Double getActualDiscount() {
        return actualDiscount;
    }

    /**
     * Sets actual discount.
     *
     * @param actualDiscount the actual discount
     */
    public void setActualDiscount(Double actualDiscount) {
        this.actualDiscount = actualDiscount;
    }

    /**
     * Gets pay terminal.
     *
     * @return the pay terminal
     */
    public String getPayTerminal() {
        return payTerminal;
    }

    /**
     * Sets pay terminal.
     *
     * @param payTerminal the pay terminal
     */
    public void setPayTerminal(String payTerminal) {
        this.payTerminal = payTerminal;
    }

    /**
     * Gets pay scene.
     *
     * @return the pay scene
     */
    public Integer getPayScene() {
        return payScene;
    }

    /**
     * Sets pay scene.
     *
     * @param payScene the pay scene
     */
    public void setPayScene(Integer payScene) {
        this.payScene = payScene;
    }

    /**
     * Gets channel id.
     *
     * @return the channel id
     */
    public String getChannelId() {
        return channelId;
    }

    /**
     * Sets channel id.
     *
     * @param channelId the channel id
     */
    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    public Long getPayTime() {
        return payTime;
    }

    public void setPayTime(Long payTime) {
        this.payTime = payTime;
    }

    @Override
    protected String method() {
        return "p2c.notify.pay";
    }
}
