package com.icetech.sdk.request.p2c.pay;

import com.icetech.sdk.request.BaseRequest;
import com.icetech.sdk.response.p2c.pay.P2cModifyFeeResponse;

/**
 * The type P 2 c modify fee request.
 *
 * @author wanggang
 * @create 2021 -07-28 9:48
 */
public class P2cModifyFeeRequest extends BaseRequest<P2cModifyFeeResponse> {

    /**
     * 停车场编号
     */
    private String parkCode;

    /**
     * 当前车辆所在的出口通道编号
     */
    private String channelCode;

    /**
     * 订单号，确保订单号在此车场内的唯一性
     */
    private String orderNum;

    /**
     * 车牌号
     */
    private String plateNum;

    /**
     * 应支付金额，保留两位小数
     */
    private String unpayPrice;

    /**
     * 修改后的支付金额，保留两位小数
     */
    private String newPrice;

    /**
     * Gets park code.
     *
     * @return the park code
     */
    public String getParkCode() {
        return parkCode;
    }

    /**
     * Sets park code.
     *
     * @param parkCode the park code
     */
    public void setParkCode(String parkCode) {
        this.parkCode = parkCode;
    }

    /**
     * Gets channel code.
     *
     * @return the channel code
     */
    public String getChannelCode() {
        return channelCode;
    }

    /**
     * Sets channel code.
     *
     * @param channelCode the channel code
     */
    public void setChannelCode(String channelCode) {
        this.channelCode = channelCode;
    }

    /**
     * Gets order num.
     *
     * @return the order num
     */
    public String getOrderNum() {
        return orderNum;
    }

    /**
     * Sets order num.
     *
     * @param orderNum the order num
     */
    public void setOrderNum(String orderNum) {
        this.orderNum = orderNum;
    }

    /**
     * Gets plate num.
     *
     * @return the plate num
     */
    public String getPlateNum() {
        return plateNum;
    }

    /**
     * Sets plate num.
     *
     * @param plateNum the plate num
     */
    public void setPlateNum(String plateNum) {
        this.plateNum = plateNum;
    }

    /**
     * Gets unpay price.
     *
     * @return the unpay price
     */
    public String getUnpayPrice() {
        return unpayPrice;
    }

    /**
     * Sets unpay price.
     *
     * @param unpayPrice the unpay price
     */
    public void setUnpayPrice(String unpayPrice) {
        this.unpayPrice = unpayPrice;
    }

    /**
     * Gets new price.
     *
     * @return the new price
     */
    public String getNewPrice() {
        return newPrice;
    }

    /**
     * Sets new price.
     *
     * @param newPrice the new price
     */
    public void setNewPrice(String newPrice) {
        this.newPrice = newPrice;
    }

    @Override
    protected String method() {
        return "p2c.modify.fee";
    }
}
