package com.icetech.sdk.request.p2c.pay;

import com.icetech.sdk.request.BaseRequest;
import com.icetech.sdk.response.p2c.pay.P2cModifyCarInfoResponse;

/**
 * 车辆信息修改接口
 *
 * @author zhangpengzhan
 * @date 2021 /1/18 14:12
 */
public class P2cModifyCarInfoRequest extends BaseRequest<P2cModifyCarInfoResponse> {
    /**
     * 云平台停车场编码
     */
    private String parkCode;

    /**
     *云平台订单号
     */
    private String orderNum;

    /**
     * 待修改的值
     */
    private String oldValue;

    /**
     * 修改后的值
     */
    private String newValue;

    /**
     * 操作类型 1 修改 2 删除（删除操作时只需要订单号）
     */
    private Integer action;

    /**
     * 修改类型 1 车牌号 2 车型 3车辆类型
     */
    private Integer modifyType;
    
    /**
     * 修改为特殊车辆类型时的描述
     */
    private String carDesc;

    /**
     * Gets park code.
     *
     * @return the park code
     */
    public String getParkCode() {
        return parkCode;
    }

    /**
     * Sets park code.
     *
     * @param parkCode the park code
     */
    public void setParkCode(String parkCode) {
        this.parkCode = parkCode;
    }

    /**
     * Gets order num.
     *
     * @return the order num
     */
    public String getOrderNum() {
        return orderNum;
    }

    /**
     * Sets order num.
     *
     * @param orderNum the order num
     */
    public void setOrderNum(String orderNum) {
        this.orderNum = orderNum;
    }

    /**
     * Gets old value.
     *
     * @return the old value
     */
    public String getOldValue() {
        return oldValue;
    }

    /**
     * Sets old value.
     *
     * @param oldValue the old value
     */
    public void setOldValue(String oldValue) {
        this.oldValue = oldValue;
    }

    /**
     * Gets new value.
     *
     * @return the new value
     */
    public String getNewValue() {
        return newValue;
    }

    /**
     * Sets new value.
     *
     * @param newValue the new value
     */
    public void setNewValue(String newValue) {
        this.newValue = newValue;
    }

    /**
     * Gets action.
     *
     * @return the action
     */
    public Integer getAction() {
        return action;
    }

    /**
     * Sets action.
     *
     * @param action the action
     */
    public void setAction(Integer action) {
        this.action = action;
    }

    /**
     * Gets modify type.
     *
     * @return the modify type
     */
    public Integer getModifyType() {
        return modifyType;
    }

    /**
     * Sets modify type.
     *
     * @param modifyType the modify type
     */
    public void setModifyType(Integer modifyType) {
        this.modifyType = modifyType;
    }

    /**
     * Gets car desc.
     *
     * @return the car desc
     */
    public String getCarDesc() {
        return carDesc;
    }

    /**
     * Sets car desc.
     *
     * @param carDesc the car desc
     */
    public void setCarDesc(String carDesc) {
        this.carDesc = carDesc;
    }

    @Override
    protected String method() {
        return "p2c.modify.car.info";
    }
}
