package com.icetech.sdk.request.p2c.pay;

import com.icetech.sdk.request.BaseRequest;
import com.icetech.sdk.response.p2c.pay.P2cDiscountNotifyResponse;

/**
 * 优惠信息通知
 * @author fangct
 */
public class P2cDiscountNotifyRequest extends BaseRequest<P2cDiscountNotifyResponse> {
    /**
     * 优惠券编号
     */
    String outDiscountNo;

    /**
     * 车场编号
     */
    String parkCode;

    /**
     * 订单号
     */
    String orderNum;

    /**
     * 车牌号
     */
    String plateNum;

    /**
     * 优惠类型，详情查看数据定义部分
     */
    int discountType;

    /**
     * 优惠数额，详情查看数据定义部分
     */
    String discountNumber;

    /**
     * 发放时间（unix时间戳）
     */
    long discountTime;

    public String getOutDiscountNo() {
        return outDiscountNo;
    }

    public void setOutDiscountNo(String outDiscountNo) {
        this.outDiscountNo = outDiscountNo;
    }

    public String getParkCode() {
        return parkCode;
    }

    public void setParkCode(String parkCode) {
        this.parkCode = parkCode;
    }

    public String getOrderNum() {
        return orderNum;
    }

    public void setOrderNum(String orderNum) {
        this.orderNum = orderNum;
    }

    public String getPlateNum() {
        return plateNum;
    }

    public void setPlateNum(String plateNum) {
        this.plateNum = plateNum;
    }

    public int getDiscountType() {
        return discountType;
    }

    public void setDiscountType(int discountType) {
        this.discountType = discountType;
    }

    public String getDiscountNumber() {
        return discountNumber;
    }

    public void setDiscountNumber(String discountNumber) {
        this.discountNumber = discountNumber;
    }

    public long getDiscountTime() {
        return discountTime;
    }

    public void setDiscountTime(long discountTime) {
        this.discountTime = discountTime;
    }

    @Override
    protected String method() {
        return "p2c.notify.discount";
    }
}
