package com.icetech.sdk.request.p2c.device;

import com.icetech.sdk.request.BaseRequest;
import com.icetech.sdk.response.p2c.device.P2cSwitchGateInfoResponse;

/**
 * 开关闸参数接口
 * @author zhangpengzhan
 * @date 2021/1/5 17:17
 */
public class P2cSwitchGateInfoRequest extends BaseRequest<P2cSwitchGateInfoResponse> {
    /**
     * 停车场编号
     */
    private String parkCode;
    /**
     * 通道编码
     */
    private String channelCode;

    /**
     * 开闸类型 1 开闸 2 关闸
     */
    private Integer switchType;

    /**
     * 车牌号
     */
    private String plateNum;
    /**
     *订单号
     */
    private String orderNum;

    /**
     * 开闸原因备注
     */
    private String reason;

    public String getParkCode() {
        return parkCode;
    }

    public void setParkCode(String parkCode) {
        this.parkCode = parkCode;
    }

    public String getChannelCode() {
        return channelCode;
    }

    public void setChannelCode(String channelCode) {
        this.channelCode = channelCode;
    }

    public Integer getSwitchType() {
        return switchType;
    }

    public void setSwitchType(Integer switchType) {
        this.switchType = switchType;
    }

    public String getPlateNum() {
        return plateNum;
    }

    public void setPlateNum(String plateNum) {
        this.plateNum = plateNum;
    }

    public String getOrderNum() {
        return orderNum;
    }

    public void setOrderNum(String orderNum) {
        this.orderNum = orderNum;
    }

    public String getReason() {
        return reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    @Override
    protected String method() {
        return "p2c.device.open";
    }

}
