package com.icetech.sdk.request.p2c.business;

import com.icetech.sdk.request.BaseRequest;
import com.icetech.sdk.response.p2c.business.P2cDelMonthCardResponse;
import com.icetech.sdk.response.p2c.business.P2cSaveBlacklistResponse;

/**
 * 保存黑名单
 *
 * @author fangct
 * @date 2024/9/4 19:55
 */
public class P2cSaveBlacklistRequest extends BaseRequest<P2cSaveBlacklistResponse> {
    /**
     * 云平台停车场编码
     */
    private String parkCode;

    /**
     * 车牌号, 多个以英文,分割
     */
    private String plateNum;

    /**
     * 姓名
     */
    private String owner;

    /**
     * 车型(2大型车、1小型车，默认1)
     */
    private Integer carType;
    /**
     * 原因
     */
    private String reason;

    /**
     * Gets park code.
     *
     * @return the park code
     */
    public String getParkCode() {
        return parkCode;
    }

    /**
     * Sets park code.
     *
     * @param parkCode the park code
     */
    public void setParkCode(String parkCode) {
        this.parkCode = parkCode;
    }

    public String getPlateNum() {
        return plateNum;
    }

    public void setPlateNum(String plateNum) {
        this.plateNum = plateNum;
    }

    public String getOwner() {
        return owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public Integer getCarType() {
        return carType;
    }

    public void setCarType(Integer carType) {
        this.carType = carType;
    }

    public String getReason() {
        return reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    @Override
    protected String method() {
        return "p2c.save.blacklist";
    }

}
