package com.icetech.sdk.request.p2c.business;

import com.alibaba.fastjson.JSON;
import com.icetech.sdk.request.BaseRequest;
import com.icetech.sdk.response.p2c.business.P2cRenewMonthCardResponse;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * The type P 2 c renew month card request.
 *
 * @author wgy
 * @date 2021 /1/14 15:01
 */
public class P2cRenewMonthCardRequest extends BaseRequest<P2cRenewMonthCardResponse> {
    
    /**
     * 车场编号
     */
    private String parkCode;
    
    /**
     * 月卡产品id
     */
    private Long productId;
    
    /**
     * 月卡id
     */
    private Long cardId;
    
    /**
     * 车位数量，默认为1，可支持多车位多车
     */
    private Integer plotCount;
    
    /**
     * 月卡有效开始日期，格式为年-月-日
     */
    private String startTime;
    
    /**
     * 月卡有效结束日期，格式为年-月-日
     */
    private String endTime;

    /**
     * 月卡范围 1=全车场 2=指定区域
     */
    private Integer mcRange;

    /**
     * 月卡区域分区编号，mcRange=2时需指定办理的月卡的分区，分区编号从车场分区列表接口中获取
     */
    private List<RegionData> regionData;

    /**
     * Gets park code.
     *
     * @return the park code
     */
    public String getParkCode() {
        return parkCode;
    }

    /**
     * Sets park code.
     *
     * @param parkCode the park code
     */
    public void setParkCode(String parkCode) {
        this.parkCode = parkCode;
    }

    /**
     * Gets product id.
     *
     * @return the product id
     */
    public Long getProductId() {
        return productId;
    }

    /**
     * Sets product id.
     *
     * @param productId the product id
     */
    public void setProductId(Long productId) {
        this.productId = productId;
    }

    /**
     * Gets card id.
     *
     * @return the card id
     */
    public Long getCardId() {
        return cardId;
    }

    /**
     * Sets card id.
     *
     * @param cardId the card id
     */
    public void setCardId(Long cardId) {
        this.cardId = cardId;
    }

    /**
     * Gets plot count.
     *
     * @return the plot count
     */
    public Integer getPlotCount() {
        return plotCount;
    }

    /**
     * Sets plot count.
     *
     * @param plotCount the plot count
     */
    public void setPlotCount(Integer plotCount) {
        this.plotCount = plotCount;
    }

    /**
     * Gets start time.
     *
     * @return the start time
     */
    public String getStartTime() {
        return startTime;
    }

    /**
     * Sets start time.
     *
     * @param startTime the start time
     */
    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    /**
     * Gets end time.
     *
     * @return the end time
     */
    public String getEndTime() {
        return endTime;
    }

    /**
     * Sets end time.
     *
     * @param endTime the end time
     */
    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    /**
     * Gets mc range.
     *
     * @return the mc range
     */
    public Integer getMcRange() {
        return mcRange;
    }

    /**
     * Sets mc range.
     *
     * @param mcRange the mc range
     */
    public void setMcRange(Integer mcRange) {
        this.mcRange = mcRange;
    }

    /**
     * Gets region data.
     *
     * @return the region data
     */
    public List<RegionData> getRegionData() {
        return regionData;
    }

    /**
     * Sets region data.
     *
     * @param regionData the region data
     */
    public void setRegionData(List<RegionData> regionData) {
        this.regionData = regionData;
    }

    /**
     * The type Region data.
     */
    public static class RegionData implements Serializable {

        /**
         * 区域编号
         */
        private String regionCode;

        /**
         * Gets region code.
         *
         * @return the region code
         */
        public String getRegionCode() {
            return regionCode;
        }

        /**
         * Sets region code.
         *
         * @param regionCode the region code
         */
        public void setRegionCode(String regionCode) {
            this.regionCode = regionCode;
        }
    }

    @Override
    protected String method() {
        return "p2c.renew.month.card";
    }

    @Override
    protected void buildBizContent(Map<String, Object> bizContent) {
        super.buildBizContent(bizContent);
        bizContent.put("regionData", JSON.toJSON(getRegionData()));
    }
}
