package com.icetech.sdk.request.p2c.business;

import com.icetech.sdk.request.BaseRequest;
import com.icetech.sdk.response.p2c.business.P2cQueryMonthCardsResponse;

/**
 * The type P 2 c query month cards request.
 *
 * @author wgy
 * @date 2021 /1/14 11:19
 */
public class P2cQueryMonthCardsRequest extends BaseRequest<P2cQueryMonthCardsResponse> {
    
    /**
     * 云平台停车场编码
     */
    private String parkCode;

    /**
     * 车牌号
     */
    private String plateNum;

    /**
     * 手机号（查询指定月卡是需要输入手机号）
     */
    private String phone;

    /**
     * 分页查询页码（默认1）
     */
    private Integer pageNum;

    /**
     * 分页查询单页数量（默认20 小于1000）
     */
    private Integer pageSize;

    /**
     * Gets park code.
     *
     * @return the park code
     */
    public String getParkCode() {
        return parkCode;
    }

    /**
     * Sets park code.
     *
     * @param parkCode the park code
     */
    public void setParkCode(String parkCode) {
        this.parkCode = parkCode;
    }

    /**
     * Gets plate num.
     *
     * @return the plate num
     */
    public String getPlateNum() {
        return plateNum;
    }

    /**
     * Sets plate num.
     *
     * @param plateNum the plate num
     */
    public void setPlateNum(String plateNum) {
        this.plateNum = plateNum;
    }

    /**
     * Gets phone.
     *
     * @return the phone
     */
    public String getPhone() {
        return phone;
    }

    /**
     * Sets phone.
     *
     * @param phone the phone
     */
    public void setPhone(String phone) {
        this.phone = phone;
    }

    /**
     * Gets page num.
     *
     * @return the page num
     */
    public Integer getPageNum() {
        return pageNum;
    }

    /**
     * Sets page num.
     *
     * @param pageNum the page num
     */
    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    /**
     * Gets page size.
     *
     * @return the page size
     */
    public Integer getPageSize() {
        return pageSize;
    }

    /**
     * Sets page size.
     *
     * @param pageSize the page size
     */
    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    @Override
    protected String method() {
        return "p2c.query.month.cards";
    }

}
