package com.icetech.sdk.request.p2c.business;

import com.icetech.sdk.request.BaseRequest;
import com.icetech.sdk.response.p2c.business.P2cEditMonthProductResponse;

import java.util.Map;

/**
 * 月卡产品编辑类
 * @author wgy
 * @date 2022/1/14 15:05
 */
public class P2cEditMonthProductRequest extends BaseRequest<P2cEditMonthProductResponse> {
    /**
     * 停车场编号
     */
    private String parkCode;
    
    /**
     * 月卡产品编号(为空是则创建新的月卡产品)
     */
    private String productId;
    
    /**
     * 月卡产品名称
     */
    private String productName;

    /**
     * 产品面额（X月）
     */
    private Integer duration;
    
    /**
     * 销售金额（元）
     */
    private String payMoney;
    
    /**
     * 月卡产品类型（1全天2分时段）
     */
    private String cardType;

    /**
     * 可用开始时间2018-10-31
     */
    private String startDate;
    
    /**
     * 可用结束时间2018-10-31
     */
    private String endDate;
    
    /**
     * 开始时间点 （月卡分时段时此参数必填产品可用时间段21:00:00）
     */
    private String startTime;
    
    /**
     * 结束时间点（跨天开始>结束，例如09:00:00）
     */
    private String endTime;
    
    /**
     * 购买渠道 0：仅平台可购买 1：平台和公众号均可购买 
     */
    private Integer buyWay;

    public String getParkCode() {
        return parkCode;
    }

    public void setParkCode(String parkCode) {
        this.parkCode = parkCode;
    }

    public String getProductId() {
        return productId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public String getProductName() {
        return productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public Integer getDuration() {
        return duration;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    public String getPayMoney() {
        return payMoney;
    }

    public void setPayMoney(String payMoney) {
        this.payMoney = payMoney;
    }

    public String getCardType() {
        return cardType;
    }

    public void setCardType(String cardType) {
        this.cardType = cardType;
    }

    public String getStartDate() {
        return startDate;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public String getEndDate() {
        return endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public String getStartTime() {
        return startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public Integer getBuyWay() {
        return buyWay;
    }

    public void setBuyWay(Integer buyWay) {
        this.buyWay = buyWay;
    }

    @Override
    protected String method() {
        return "p2c.edit.month.product";
    }

}
