package com.icetech.sdk.request.p2c.business;

import com.alibaba.fastjson.JSON;
import com.icetech.sdk.request.BaseRequest;
import com.icetech.sdk.response.p2c.business.P2cEditMonthCardResponse;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * Description EditMonthCardRequest
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2022/7/11 13:54
 */
public class P2cEditMonthCardRequest extends BaseRequest<P2cEditMonthCardResponse> {
    
    /**
     * 月卡状态（1：正常，2：禁用。）
     */
    private Integer cardStatus;

    /**
     * 云平台月卡编号，此月卡的唯一标识
     */
    private String cardId;

    /**
     * 云平台停车场编码
     */
    private String parkCode;

    /**
     * 月卡套餐编号（通过月卡套餐查询接口获取）
     */
    private Long productId;

    /**
     * 手机号
     */
    private String phone;

    /**
     * 月卡申办性质，详情查看数据定义部分
     */
    private Integer cardProperty;

    /**
     * 用户姓名/公司名称
     */
    private String cardOwner;

    /**
     * 车牌号,可以多个。会以”/“连接。比如车牌号信息：京JS7680/京JS7681/京JS7682/京JS7683/京JS7684/京JS7685
     */
    private String plateNum;

    /**
     * 月卡开始日期，格式为yyyy-MM-dd 如2017-07-01
     */
    private String startDate;

    /**
     * 月卡结束日期，格式为yyyy-MM-dd 如2017-07-31
     */
    private String endDate;

    /**
     * 车位数量，默认为1，可支持多车位多车
     */
    private Integer plotCount;

    /**
     * 车位号,可以多个。会以”/“连接。车位号的多少和车位数量保持一致，比如车位信息：A001 / A002/ A003"
     */
    private String plotNum;

    /**
     * 金额，单位：元
     */
    private String payMoney;

    /**
     * 办理时间（unix时间戳秒)
     */
    private Long operTime;

    /**
     * 月卡范围 1=全车场 2=指定区域
     */
    private Integer mcRange;

    /**
     * 月卡区域分区编号，mcRange=2时需指定办理的月卡的分区，分区编号从车场分区列表接口中获取 （场中场全车场需传regionCode=0）
     */
    private List<RegionData> regionData;

    /**
     * Gets card status.
     *
     * @return the card status
     */
    public Integer getCardStatus() {
        return cardStatus;
    }

    /**
     * Sets card status.
     *
     * @param cardStatus the card status
     */
    public void setCardStatus(Integer cardStatus) {
        this.cardStatus = cardStatus;
    }

    /**
     * Gets card id.
     *
     * @return the card id
     */
    public String getCardId() {
        return cardId;
    }

    /**
     * Sets card id.
     *
     * @param cardId the card id
     */
    public void setCardId(String cardId) {
        this.cardId = cardId;
    }

    /**
     * Gets park code.
     *
     * @return the park code
     */
    public String getParkCode() {
        return parkCode;
    }

    /**
     * Sets park code.
     *
     * @param parkCode the park code
     */
    public void setParkCode(String parkCode) {
        this.parkCode = parkCode;
    }

    /**
     * Gets product id.
     *
     * @return the product id
     */
    public Long getProductId() {
        return productId;
    }

    /**
     * Sets product id.
     *
     * @param productId the product id
     */
    public void setProductId(Long productId) {
        this.productId = productId;
    }

    /**
     * Gets phone.
     *
     * @return the phone
     */
    public String getPhone() {
        return phone;
    }

    /**
     * Sets phone.
     *
     * @param phone the phone
     */
    public void setPhone(String phone) {
        this.phone = phone;
    }

    /**
     * Gets card property.
     *
     * @return the card property
     */
    public Integer getCardProperty() {
        return cardProperty;
    }

    /**
     * Sets card property.
     *
     * @param cardProperty the card property
     */
    public void setCardProperty(Integer cardProperty) {
        this.cardProperty = cardProperty;
    }

    /**
     * Gets card owner.
     *
     * @return the card owner
     */
    public String getCardOwner() {
        return cardOwner;
    }

    /**
     * Sets card owner.
     *
     * @param cardOwner the card owner
     */
    public void setCardOwner(String cardOwner) {
        this.cardOwner = cardOwner;
    }

    /**
     * Gets plate num.
     *
     * @return the plate num
     */
    public String getPlateNum() {
        return plateNum;
    }

    /**
     * Sets plate num.
     *
     * @param plateNum the plate num
     */
    public void setPlateNum(String plateNum) {
        this.plateNum = plateNum;
    }

    /**
     * Gets start date.
     *
     * @return the start date
     */
    public String getStartDate() {
        return startDate;
    }

    /**
     * Sets start date.
     *
     * @param startDate the start date
     */
    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    /**
     * Gets end date.
     *
     * @return the end date
     */
    public String getEndDate() {
        return endDate;
    }

    /**
     * Sets end date.
     *
     * @param endDate the end date
     */
    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    /**
     * Gets plot count.
     *
     * @return the plot count
     */
    public Integer getPlotCount() {
        return plotCount;
    }

    /**
     * Sets plot count.
     *
     * @param plotCount the plot count
     */
    public void setPlotCount(Integer plotCount) {
        this.plotCount = plotCount;
    }

    /**
     * Gets plot num.
     *
     * @return the plot num
     */
    public String getPlotNum() {
        return plotNum;
    }

    /**
     * Sets plot num.
     *
     * @param plotNum the plot num
     */
    public void setPlotNum(String plotNum) {
        this.plotNum = plotNum;
    }

    /**
     * Gets pay money.
     *
     * @return the pay money
     */
    public String getPayMoney() {
        return payMoney;
    }

    /**
     * Sets pay money.
     *
     * @param payMoney the pay money
     */
    public void setPayMoney(String payMoney) {
        this.payMoney = payMoney;
    }

    /**
     * Gets oper time.
     *
     * @return the oper time
     */
    public Long getOperTime() {
        return operTime;
    }

    /**
     * Sets oper time.
     *
     * @param operTime the oper time
     */
    public void setOperTime(Long operTime) {
        this.operTime = operTime;
    }

    /**
     * Gets mc range.
     *
     * @return the mc range
     */
    public Integer getMcRange() {
        return mcRange;
    }

    /**
     * Sets mc range.
     *
     * @param mcRange the mc range
     */
    public void setMcRange(Integer mcRange) {
        this.mcRange = mcRange;
    }

    /**
     * Gets region data.
     *
     * @return the region data
     */
    public List<RegionData> getRegionData() {
        return regionData;
    }

    /**
     * Sets region data.
     *
     * @param regionData the region data
     */
    public void setRegionData(List<RegionData> regionData) {
        this.regionData = regionData;
    }

    /**
     * The type Region data.
     */
    public static class RegionData implements Serializable {

        /**
         * 区域编号
         */
        private String regionCode;

        /**
         * Gets region code.
         *
         * @return the region code
         */
        public String getRegionCode() {
            return regionCode;
        }

        /**
         * Sets region code.
         *
         * @param regionCode the region code
         */
        public void setRegionCode(String regionCode) {
            this.regionCode = regionCode;
        }
    }

    @Override
    protected String method() {
        return "p2c.edit.month.card";
    }

    @Override
    protected void buildBizContent(Map<String, Object> bizContent) {
        super.buildBizContent(bizContent);
        bizContent.put("regionData", JSON.toJSON(getRegionData()));
    }

}
