package com.icetech.sdk.request.p2c.business;

import com.icetech.sdk.request.BaseRequest;
import com.icetech.sdk.response.p2c.business.P2cDelMonthProductResponse;

import java.util.List;

/**
 * 删除月卡产品
 *
 * @author zhangpengzhan
 * @date 2021 /1/14 16:45
 */
public class P2cDelMonthProductRequest extends BaseRequest<P2cDelMonthProductResponse> {
    
    /**
     * 停车场编号
     */
    private String parkCode;
    
    /**
     * 月卡套餐id集合
     */
    private List<String> productId;

    /**
     * Gets park code.
     *
     * @return the park code
     */
    public String getParkCode() {
        return parkCode;
    }

    /**
     * Sets park code.
     *
     * @param parkCode the park code
     */
    public void setParkCode(String parkCode) {
        this.parkCode = parkCode;
    }

    /**
     * Gets product id.
     *
     * @return the product id
     */
    public List<String> getProductId() {
        return productId;
    }

    /**
     * Sets product id.
     *
     * @param productId the product id
     */
    public void setProductId(List<String> productId) {
        this.productId = productId;
    }

    @Override
    protected String method() {
        return "p2c.del.month.product";
    }

}
