package com.icetech.sdk.request.p2c.business;

import com.icetech.sdk.request.BaseRequest;
import com.icetech.sdk.response.p2c.business.P2cDelMonthCardResponse;

/**
 * 清除月卡信息
 *
 * @author zhangpengzhan
 * @date 2021 /1/14 11:12
 */
public class P2cDelMonthCardRequest extends BaseRequest<P2cDelMonthCardResponse> {
    /**
     * 云平台停车场编码
     */
    private String parkCode;

    /**
     * 是否清除整个车场月卡 1否 2 是
     */
    private Integer isDelAll;

    /**
     * 云平台月卡ID号，此月卡的唯一标识
     */
    private Long cardId;

    /**
     * Gets park code.
     *
     * @return the park code
     */
    public String getParkCode() {
        return parkCode;
    }

    /**
     * Sets park code.
     *
     * @param parkCode the park code
     */
    public void setParkCode(String parkCode) {
        this.parkCode = parkCode;
    }

    /**
     * Gets is del all.
     *
     * @return the is del all
     */
    public Integer getIsDelAll() {
        return isDelAll;
    }

    /**
     * Sets is del all.
     *
     * @param isDelAll the is del all
     */
    public void setIsDelAll(Integer isDelAll) {
        this.isDelAll = isDelAll;
    }

    /**
     * Gets card id.
     *
     * @return the card id
     */
    public Long getCardId() {
        return cardId;
    }

    /**
     * Sets card id.
     *
     * @param cardId the card id
     */
    public void setCardId(Long cardId) {
        this.cardId = cardId;
    }

    @Override
    protected String method() {
        return "p2c.del.month.card";
    }

}
