package com.icetech.sdk.request.p2c.business;

import com.icetech.sdk.request.BaseRequest;
import com.icetech.sdk.response.p2c.business.P2cDelBlacklistResponse;
import com.icetech.sdk.response.p2c.business.P2cDelMonthCardResponse;

/**
 * 清除黑名单
 *
 * @author fangct
 * @date 2024/9/4 19:55
 */
public class P2cDelBlacklistRequest extends BaseRequest<P2cDelBlacklistResponse> {
    /**
     * 云平台停车场编码
     */
    private String parkCode;

    /**
     * 车牌号, 多个以英文,分割
     */
    private String plateNum;

    /**
     * Gets park code.
     *
     * @return the park code
     */
    public String getParkCode() {
        return parkCode;
    }

    /**
     * Sets park code.
     *
     * @param parkCode the park code
     */
    public void setParkCode(String parkCode) {
        this.parkCode = parkCode;
    }

    public String getPlateNum() {
        return plateNum;
    }

    public void setPlateNum(String plateNum) {
        this.plateNum = plateNum;
    }


    @Override
    protected String method() {
        return "p2c.del.blacklist";
    }

}
