package com.icetech.sdk.request.p2c.base;

import com.icetech.sdk.request.BaseRequest;
import com.icetech.sdk.response.p2c.base.P2cSaveParkSeniorInfoResponse;

/**
 * Description P2cSaveParkSeniorInfoRequest
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2022/7/8 11:37
 */
public class P2cSaveParkSeniorInfoRequest extends BaseRequest<P2cSaveParkSeniorInfoResponse> {

    /**
     * 所属停车场编号
     */
    private String parkCode;

    /**
     * 剩余多少空车位时，禁止入场
     */
    private Integer fullEmptynum;

    /**
     * 在车位满的情况下，是否禁止临时车入内，0：否 1：是， 默认为0
     */
    private Integer isFullForbidenter;

    /**
     * 在车位满的情况下，是否禁止月卡车入内
     */
    private Integer isFullForbidmonthenter;

    /**
     * 在车位满的情况下，是否禁止VIP车入内，0：否 1：
     */
    private Integer isFullForbidvipenter;

    /**
     * 在车位满的情况下，是否禁止预约车入内，0：否 1：是
     */
    private Integer isFullForbidreserventer;

    /**
     * 在车位满的情况下，是否禁止储值车入内，0：否 1：是
     */
    private Integer isFullForbidstoreenter;

    /**
     * 月卡车是否计入总车位数1是 2 否 默认是2
     */
    private Integer isCardcount;

    /**
     * 车辆出入口停留多长时间监控坐席提醒
     */
    private Integer carenexTimelong;

    /**
     * 入场到出场最小时间值，以秒为单位，默认值是0，如果车辆出场时总停车时长小于x秒出场不进行任何处
     */
    private Integer enexMinTime;

    /**
     * 出场到入场最小时间值，以秒为单位，默认值是0，如果车辆入场时上次出场时间至当前时间时间差小于x秒入场不进行任何处理
     */
    private Integer exenMinTime;

    /**
     * 显示终端类型，1：LED，2：LCD
     */
    private Integer displayTerminal;

    /**
     * 控制卡型号 18：方控 19：科发 27：瑞
     */
    private Integer ledcardType;

    /**
     * 是否有TTS 0无,1有
     */
    private int ttsType;

    /**
     * 计费精度 0：分钟，1：秒 默认0
     */
    private int billPrecision;

    /**
     * 军警车是否免费停车 0：不免费 1：免费 默认1
     */
    private Integer isfreeSpecialcar;

    /**
     * AB车场内切换X时间不收费，单位分钟
     */
    private Integer switchTm;

    /**
     * 支持多车位管理超时处理规则1：B车计费结束时间按A车出场时间收费 ，2：B车计费结束时间按B车出场时间收费 默认为
     */
    private Integer switchType;

    /**
     * 免费时间内是否自动抬杆 0：不自动 1：自动 默认为1
     */
    private Integer isreleaseFreetm;

    /**
     * 免费时长是否计入停车费用1：是 2：否 默认为2
     */
    private Integer freetimeStatus;


    /**
     * 是否补时 1是2否 默认为1
     */
    private Integer isFilltime;

    /**
     * 超时计费起始时间1末次缴费时间 2车辆入场时间 默认为1
     */
    private Integer overtimeBillType;

    /**
     * 是否允许二次使用免费时长 1不允许2允许 默认为1
     */
    private Integer isallowfreetmonce;

    /**
     * 收费是否抹零头1是2否 默认为1
     */
    private Integer isnotgetsmallchange;

    /**
     * 小型车无入场记录时的固定费用（单位元）
     */
    private Integer fixedfeevalue;

    /**
     * 大型车无入场记录时的固定费用（单位元）
     */
    private Integer fixedFeeValueBig;

    /**
     * 是否允许无牌车重复入场，0：否 1：是， 默认为0
     */
    private Integer isNoplateRepeatenter;

    /**
     * 是否支持AB车管理 0：不支持 1：支持 默认0
     */
    private Integer issupAbmanage;

    /**
     * 出场查无入场记录、支持固定收费1是2否 默认为2
     */
    private Integer isfixedfees;

    /**
     * 是否特殊车场（存在进出共用一个通道的车场）0不是，1是 默认是0
     */
    private Integer isSpecialPark;

    public String getParkCode() {
        return parkCode;
    }

    public void setParkCode(String parkCode) {
        this.parkCode = parkCode;
    }

    public Integer getFullEmptynum() {
        return fullEmptynum;
    }

    public void setFullEmptynum(Integer fullEmptynum) {
        this.fullEmptynum = fullEmptynum;
    }

    public Integer getIsFullForbidenter() {
        return isFullForbidenter;
    }

    public void setIsFullForbidenter(Integer isFullForbidenter) {
        this.isFullForbidenter = isFullForbidenter;
    }

    public Integer getIsFullForbidmonthenter() {
        return isFullForbidmonthenter;
    }

    public void setIsFullForbidmonthenter(Integer isFullForbidmonthenter) {
        this.isFullForbidmonthenter = isFullForbidmonthenter;
    }

    public Integer getIsFullForbidvipenter() {
        return isFullForbidvipenter;
    }

    public void setIsFullForbidvipenter(Integer isFullForbidvipenter) {
        this.isFullForbidvipenter = isFullForbidvipenter;
    }

    public Integer getIsFullForbidreserventer() {
        return isFullForbidreserventer;
    }

    public void setIsFullForbidreserventer(Integer isFullForbidreserventer) {
        this.isFullForbidreserventer = isFullForbidreserventer;
    }

    public Integer getIsFullForbidstoreenter() {
        return isFullForbidstoreenter;
    }

    public void setIsFullForbidstoreenter(Integer isFullForbidstoreenter) {
        this.isFullForbidstoreenter = isFullForbidstoreenter;
    }

    public Integer getIsCardcount() {
        return isCardcount;
    }

    public void setIsCardcount(Integer isCardcount) {
        this.isCardcount = isCardcount;
    }

    public Integer getCarenexTimelong() {
        return carenexTimelong;
    }

    public void setCarenexTimelong(Integer carenexTimelong) {
        this.carenexTimelong = carenexTimelong;
    }

    public Integer getEnexMinTime() {
        return enexMinTime;
    }

    public void setEnexMinTime(Integer enexMinTime) {
        this.enexMinTime = enexMinTime;
    }

    public Integer getExenMinTime() {
        return exenMinTime;
    }

    public void setExenMinTime(Integer exenMinTime) {
        this.exenMinTime = exenMinTime;
    }

    public Integer getDisplayTerminal() {
        return displayTerminal;
    }

    public void setDisplayTerminal(Integer displayTerminal) {
        this.displayTerminal = displayTerminal;
    }

    public Integer getLedcardType() {
        return ledcardType;
    }

    public void setLedcardType(Integer ledcardType) {
        this.ledcardType = ledcardType;
    }

    public int getTtsType() {
        return ttsType;
    }

    public void setTtsType(int ttsType) {
        this.ttsType = ttsType;
    }

    public int getBillPrecision() {
        return billPrecision;
    }

    public void setBillPrecision(int billPrecision) {
        this.billPrecision = billPrecision;
    }

    public Integer getIsfreeSpecialcar() {
        return isfreeSpecialcar;
    }

    public void setIsfreeSpecialcar(Integer isfreeSpecialcar) {
        this.isfreeSpecialcar = isfreeSpecialcar;
    }

    public Integer getSwitchTm() {
        return switchTm;
    }

    public void setSwitchTm(Integer switchTm) {
        this.switchTm = switchTm;
    }

    public Integer getSwitchType() {
        return switchType;
    }

    public void setSwitchType(Integer switchType) {
        this.switchType = switchType;
    }

    public Integer getIsreleaseFreetm() {
        return isreleaseFreetm;
    }

    public void setIsreleaseFreetm(Integer isreleaseFreetm) {
        this.isreleaseFreetm = isreleaseFreetm;
    }

    public Integer getFreetimeStatus() {
        return freetimeStatus;
    }

    public void setFreetimeStatus(Integer freetimeStatus) {
        this.freetimeStatus = freetimeStatus;
    }

    public Integer getIsFilltime() {
        return isFilltime;
    }

    public void setIsFilltime(Integer isFilltime) {
        this.isFilltime = isFilltime;
    }

    public Integer getOvertimeBillType() {
        return overtimeBillType;
    }

    public void setOvertimeBillType(Integer overtimeBillType) {
        this.overtimeBillType = overtimeBillType;
    }

    public Integer getIsallowfreetmonce() {
        return isallowfreetmonce;
    }

    public void setIsallowfreetmonce(Integer isallowfreetmonce) {
        this.isallowfreetmonce = isallowfreetmonce;
    }

    public Integer getIsnotgetsmallchange() {
        return isnotgetsmallchange;
    }

    public void setIsnotgetsmallchange(Integer isnotgetsmallchange) {
        this.isnotgetsmallchange = isnotgetsmallchange;
    }

    public Integer getFixedfeevalue() {
        return fixedfeevalue;
    }

    public void setFixedfeevalue(Integer fixedfeevalue) {
        this.fixedfeevalue = fixedfeevalue;
    }

    public Integer getFixedFeeValueBig() {
        return fixedFeeValueBig;
    }

    public void setFixedFeeValueBig(Integer fixedFeeValueBig) {
        this.fixedFeeValueBig = fixedFeeValueBig;
    }

    public Integer getIsNoplateRepeatenter() {
        return isNoplateRepeatenter;
    }

    public void setIsNoplateRepeatenter(Integer isNoplateRepeatenter) {
        this.isNoplateRepeatenter = isNoplateRepeatenter;
    }

    public Integer getIssupAbmanage() {
        return issupAbmanage;
    }

    public void setIssupAbmanage(Integer issupAbmanage) {
        this.issupAbmanage = issupAbmanage;
    }

    public Integer getIsfixedfees() {
        return isfixedfees;
    }

    public void setIsfixedfees(Integer isfixedfees) {
        this.isfixedfees = isfixedfees;
    }

    public Integer getIsSpecialPark() {
        return isSpecialPark;
    }

    public void setIsSpecialPark(Integer isSpecialPark) {
        this.isSpecialPark = isSpecialPark;
    }

    @Override
    protected String method() {
        return "p2c.save.park.senior.info";
    }

}
