package com.icetech.sdk.request.p2c.base;

import com.icetech.sdk.request.BaseRequest;
import com.icetech.sdk.response.p2c.base.P2cSaveParkResponse;

/**
 * Description SaveParkRequest
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2022/7/14 09:45
 */
public class P2cSaveParkRequest extends BaseRequest<P2cSaveParkResponse> {

    /**
     * 停车场编号，新增车场时，不传此值
     */
    private String parkCode;

    /**
     * 停车场名称
     */
    private String parkName;

    /**
     * 联系电话
     */
    private String phone;

    /**
     * 省级区域ID
     */
    private Integer provinceId;

    /**
     * 车场所属城市
     */
    private Integer cityId;

    /**
     * 所属区域
     */
    private Integer districtId;

    /**
     * 总车位数
     */
    private Integer totalNum;

    /**
     * 车场地址
     */
    private String address;

    private Integer dataCollection;

    /**
     *停车场属性
     */
    private Integer parkProperty = 5;

    /**
     * 车场经度
     */
    private String lat;
    
    /**
     * 车场纬度
     */
    private String lng;

    /**
     * 空位数
     */
    private Integer freeSpace;

    /**
     * 车场类型（0:室内、1：室外、2：室内+室外、3：占道 默认：0
     */
    private int parkType;

    /**
     * 是否存在场中场(0否，1是默认0)
     */
    private int isInterior;

    /**
     * 场中场切换免费时长 分钟
     */
    private Integer switchFeeTime;

    /**
     * 资产类型(1产权、2管理权、3经营权默认0)
     */
    private Integer assetType;

    /**
     *入口数量
     */
    private Integer totalEnter;

    /**
     *出口数量
     */
    private Integer totalExit;

    /**
     * 合作方式(1自营、2合作、3加盟默认0)
     */
    private Integer cooperateType;

    /**
     * Gets park code.
     *
     * @return the park code
     */
    public String getParkCode() {
        return parkCode;
    }

    /**
     * Sets park code.
     *
     * @param parkCode the park code
     */
    public void setParkCode(String parkCode) {
        this.parkCode = parkCode;
    }

    /**
     * Gets park name.
     *
     * @return the park name
     */
    public String getParkName() {
        return parkName;
    }

    /**
     * Sets park name.
     *
     * @param parkName the park name
     */
    public void setParkName(String parkName) {
        this.parkName = parkName;
    }

    /**
     * Gets phone.
     *
     * @return the phone
     */
    public String getPhone() {
        return phone;
    }

    /**
     * Sets phone.
     *
     * @param phone the phone
     */
    public void setPhone(String phone) {
        this.phone = phone;
    }

    /**
     * Gets province id.
     *
     * @return the province id
     */
    public Integer getProvinceId() {
        return provinceId;
    }

    /**
     * Sets province id.
     *
     * @param provinceId the province id
     */
    public void setProvinceId(Integer provinceId) {
        this.provinceId = provinceId;
    }

    /**
     * Gets city id.
     *
     * @return the city id
     */
    public Integer getCityId() {
        return cityId;
    }

    /**
     * Sets city id.
     *
     * @param cityId the city id
     */
    public void setCityId(Integer cityId) {
        this.cityId = cityId;
    }

    /**
     * Gets district id.
     *
     * @return the district id
     */
    public Integer getDistrictId() {
        return districtId;
    }

    /**
     * Sets district id.
     *
     * @param districtId the district id
     */
    public void setDistrictId(Integer districtId) {
        this.districtId = districtId;
    }

    /**
     * Gets total num.
     *
     * @return the total num
     */
    public Integer getTotalNum() {
        return totalNum;
    }

    /**
     * Sets total num.
     *
     * @param totalNum the total num
     */
    public void setTotalNum(Integer totalNum) {
        this.totalNum = totalNum;
    }

    /**
     * Gets address.
     *
     * @return the address
     */
    public String getAddress() {
        return address;
    }

    /**
     * Sets address.
     *
     * @param address the address
     */
    public void setAddress(String address) {
        this.address = address;
    }

    /**
     * Gets data collection.
     *
     * @return the data collection
     */
    public Integer getDataCollection() {
        return dataCollection;
    }

    /**
     * Sets data collection.
     *
     * @param dataCollection the data collection
     */
    public void setDataCollection(Integer dataCollection) {
        this.dataCollection = dataCollection;
    }

    /**
     * Gets park property.
     *
     * @return the park property
     */
    public Integer getParkProperty() {
        return parkProperty;
    }

    /**
     * Sets park property.
     *
     * @param parkProperty the park property
     */
    public void setParkProperty(Integer parkProperty) {
        this.parkProperty = parkProperty;
    }

    /**
     * Gets lat.
     *
     * @return the lat
     */
    public String getLat() {
        return lat;
    }

    /**
     * Sets lat.
     *
     * @param lat the lat
     */
    public void setLat(String lat) {
        this.lat = lat;
    }

    /**
     * Gets lng.
     *
     * @return the lng
     */
    public String getLng() {
        return lng;
    }

    /**
     * Sets lng.
     *
     * @param lng the lng
     */
    public void setLng(String lng) {
        this.lng = lng;
    }

    /**
     * Gets free space.
     *
     * @return the free space
     */
    public Integer getFreeSpace() {
        return freeSpace;
    }

    /**
     * Sets free space.
     *
     * @param freeSpace the free space
     */
    public void setFreeSpace(Integer freeSpace) {
        this.freeSpace = freeSpace;
    }

    /**
     * Gets park type.
     *
     * @return the park type
     */
    public int getParkType() {
        return parkType;
    }

    /**
     * Sets park type.
     *
     * @param parkType the park type
     */
    public void setParkType(int parkType) {
        this.parkType = parkType;
    }

    /**
     * Gets is interior.
     *
     * @return the is interior
     */
    public int getIsInterior() {
        return isInterior;
    }

    /**
     * Sets is interior.
     *
     * @param isInterior the is interior
     */
    public void setIsInterior(int isInterior) {
        this.isInterior = isInterior;
    }

    /**
     * Gets switch fee time.
     *
     * @return the switch fee time
     */
    public Integer getSwitchFeeTime() {
        return switchFeeTime;
    }

    /**
     * Sets switch fee time.
     *
     * @param switchFeeTime the switch fee time
     */
    public void setSwitchFeeTime(Integer switchFeeTime) {
        this.switchFeeTime = switchFeeTime;
    }

    /**
     * Gets asset type.
     *
     * @return the asset type
     */
    public Integer getAssetType() {
        return assetType;
    }

    /**
     * Sets asset type.
     *
     * @param assetType the asset type
     */
    public void setAssetType(Integer assetType) {
        this.assetType = assetType;
    }

    /**
     * Gets total enter.
     *
     * @return the total enter
     */
    public Integer getTotalEnter() {
        return totalEnter;
    }

    /**
     * Sets total enter.
     *
     * @param totalEnter the total enter
     */
    public void setTotalEnter(Integer totalEnter) {
        this.totalEnter = totalEnter;
    }

    /**
     * Gets total exit.
     *
     * @return the total exit
     */
    public Integer getTotalExit() {
        return totalExit;
    }

    /**
     * Sets total exit.
     *
     * @param totalExit the total exit
     */
    public void setTotalExit(Integer totalExit) {
        this.totalExit = totalExit;
    }

    /**
     * Gets cooperate type.
     *
     * @return the cooperate type
     */
    public Integer getCooperateType() {
        return cooperateType;
    }

    /**
     * Sets cooperate type.
     *
     * @param cooperateType the cooperate type
     */
    public void setCooperateType(Integer cooperateType) {
        this.cooperateType = cooperateType;
    }

    @Override
    protected String method() {
        return "p2c.save.park";
    }
}
