package com.icetech.sdk.request.p2c.base;

import com.alibaba.fastjson.JSON;
import com.icetech.sdk.request.BaseRequest;
import com.icetech.sdk.response.p2c.base.P2cSaveChannelResponse;

import java.io.Serializable;
import java.util.Map;

/**
 * Description P2cSaveParkSeniorInfoRequest
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2022/7/8 11:37
 */
public class P2cSaveChannelRequest extends BaseRequest<P2cSaveChannelResponse> {

    /**
     * 停车场编号（系统自动生成）
     */
    private String parkCode;

    /**
     * 通道编号，编辑时必传
     */
    private String inandoutCode;

    /**
     * 通道名称
     */
    private String inandoutName;

    /**
     * 通道类型，1入口 2出口
     */
    private Integer inandoutType;

    /**
     * 是否是主通道 1=是 0=否，默认为1
     */
    private Integer isMaster;

    /**
     * 区域编号
     */
    private String regionCode;

    /**
     * 是否收费 1=是 0=否
     */
    private Integer isCharge;

    /**
     * 是否允许临时车进出 0:不允许 1：允许，默认1
     */
    private Integer isAllowTempcarrun;

    /**
     * 是否允许无牌车扫码进出 0:不允许 1：允许，默认1
     */
    private Integer isAllowNocardrun;

    /**
     * 黄牌车是否允许进 0:不开启 1：开启，默认1
     */
    private Integer isAllowYellowcarrun;

    /**
     * 是否开启模糊识别 0:不开启 1：开启，默认0
     */
    private Integer isOpenVaguetype;

    /**
     * 模糊模式 0：去汉字 1：去汉字1位 2：去汉字2位
     */
    private Integer vaguetype;

    /**
     * 是否允许新能源车辆进出 0：不允许 1：允许
     */
    private Integer isAllowNewenergycarrun;

    /**
     * 是否允许预约车进出0：不允许，1：允许
     */
    private Integer isAllowVisitCar;

    /**
     * 是否允月卡车车进出0：不允许，1：允许
     */
    private Integer isAllowMonthCar;

    /**
     * 是否允许过期月卡车进出0：不允许，1：允许
     */
    private Integer isAllowOvertimeCar;

    /**
     * 过期天数 isOverTimeMonth=1必填
     */
    private Integer overTimeDay;

    /**
     * 过期卡是否按月卡处理0：否，1：是 isOverTimeMonth=1必填
     */
    private Integer overTimeMonthlyCard;

    /**
     * 是否允许多位多车月卡车进出1=是 0=否，默认1
     */
    private Integer isAllowABcar;

    /**
     * 是否允许黑名单车进出0：不允许，1：允许，默认0
     */
    private Integer isAllowBackCar;

    /**
     * 是否允许储值卡车进出0：不允许，1：允许，默认1
     */
    private Integer isAllowStoredCar;

    /**
     * 是否允许Vip车进出0：不允许，1：允许，默认1
     */
    private Integer isAllowVipCar;

    /**
     * vip车场类型，多个以逗号隔开
     */
    private String vipCarType;

    /**
     * 主识别相机
     */
    private MainCamera mainCamera;

    /**
     * 辅识别相机
     */
    private SecoCamera secoCamera;

    /**
     * 智能机器人
     */
    private RobotDev robotDev;

    /**
     * 语音对讲设备
     */
    private VoiceDev voiceDev;

    /**
     * 监控相机设备
     */
    private MonitorDev monitorDev;

    /**
     * 对讲缴费终端
     */
    private IntercomPillarDev intercomPillarDev;

    public String getParkCode() {
        return parkCode;
    }

    public void setParkCode(String parkCode) {
        this.parkCode = parkCode;
    }

    public String getInandoutCode() {
        return inandoutCode;
    }

    public void setInandoutCode(String inandoutCode) {
        this.inandoutCode = inandoutCode;
    }

    public String getInandoutName() {
        return inandoutName;
    }

    public void setInandoutName(String inandoutName) {
        this.inandoutName = inandoutName;
    }

    public Integer getInandoutType() {
        return inandoutType;
    }

    public void setInandoutType(Integer inandoutType) {
        this.inandoutType = inandoutType;
    }

    public Integer getIsMaster() {
        return isMaster;
    }

    public void setIsMaster(Integer isMaster) {
        this.isMaster = isMaster;
    }

    public String getRegionCode() {
        return regionCode;
    }

    public void setRegionCode(String regionCode) {
        this.regionCode = regionCode;
    }

    public Integer getIsCharge() {
        return isCharge;
    }

    public void setIsCharge(Integer isCharge) {
        this.isCharge = isCharge;
    }

    public Integer getIsAllowTempcarrun() {
        return isAllowTempcarrun;
    }

    public void setIsAllowTempcarrun(Integer isAllowTempcarrun) {
        this.isAllowTempcarrun = isAllowTempcarrun;
    }

    public Integer getIsAllowNocardrun() {
        return isAllowNocardrun;
    }

    public void setIsAllowNocardrun(Integer isAllowNocardrun) {
        this.isAllowNocardrun = isAllowNocardrun;
    }

    public Integer getIsAllowYellowcarrun() {
        return isAllowYellowcarrun;
    }

    public void setIsAllowYellowcarrun(Integer isAllowYellowcarrun) {
        this.isAllowYellowcarrun = isAllowYellowcarrun;
    }

    public Integer getIsOpenVaguetype() {
        return isOpenVaguetype;
    }

    public void setIsOpenVaguetype(Integer isOpenVaguetype) {
        this.isOpenVaguetype = isOpenVaguetype;
    }

    public Integer getVaguetype() {
        return vaguetype;
    }

    public void setVaguetype(Integer vaguetype) {
        this.vaguetype = vaguetype;
    }

    public Integer getIsAllowNewenergycarrun() {
        return isAllowNewenergycarrun;
    }

    public void setIsAllowNewenergycarrun(Integer isAllowNewenergycarrun) {
        this.isAllowNewenergycarrun = isAllowNewenergycarrun;
    }

    public Integer getIsAllowVisitCar() {
        return isAllowVisitCar;
    }

    public void setIsAllowVisitCar(Integer isAllowVisitCar) {
        this.isAllowVisitCar = isAllowVisitCar;
    }

    public Integer getIsAllowMonthCar() {
        return isAllowMonthCar;
    }

    public void setIsAllowMonthCar(Integer isAllowMonthCar) {
        this.isAllowMonthCar = isAllowMonthCar;
    }

    public Integer getIsAllowOvertimeCar() {
        return isAllowOvertimeCar;
    }

    public void setIsAllowOvertimeCar(Integer isAllowOvertimeCar) {
        this.isAllowOvertimeCar = isAllowOvertimeCar;
    }

    public Integer getOverTimeDay() {
        return overTimeDay;
    }

    public void setOverTimeDay(Integer overTimeDay) {
        this.overTimeDay = overTimeDay;
    }

    public Integer getOverTimeMonthlyCard() {
        return overTimeMonthlyCard;
    }

    public void setOverTimeMonthlyCard(Integer overTimeMonthlyCard) {
        this.overTimeMonthlyCard = overTimeMonthlyCard;
    }

    public Integer getIsAllowABcar() {
        return isAllowABcar;
    }

    public void setIsAllowABcar(Integer isAllowABcar) {
        this.isAllowABcar = isAllowABcar;
    }

    public Integer getIsAllowBackCar() {
        return isAllowBackCar;
    }

    public void setIsAllowBackCar(Integer isAllowBackCar) {
        this.isAllowBackCar = isAllowBackCar;
    }

    public Integer getIsAllowStoredCar() {
        return isAllowStoredCar;
    }

    public void setIsAllowStoredCar(Integer isAllowStoredCar) {
        this.isAllowStoredCar = isAllowStoredCar;
    }

    public Integer getIsAllowVipCar() {
        return isAllowVipCar;
    }

    public void setIsAllowVipCar(Integer isAllowVipCar) {
        this.isAllowVipCar = isAllowVipCar;
    }

    public String getVipCarType() {
        return vipCarType;
    }

    public void setVipCarType(String vipCarType) {
        this.vipCarType = vipCarType;
    }

    public MainCamera getMainCamera() {
        return mainCamera;
    }

    public void setMainCamera(MainCamera mainCamera) {
        this.mainCamera = mainCamera;
    }

    public SecoCamera getSecoCamera() {
        return secoCamera;
    }

    public void setSecoCamera(SecoCamera secoCamera) {
        this.secoCamera = secoCamera;
    }

    public RobotDev getRobotDev() {
        return robotDev;
    }

    public void setRobotDev(RobotDev robotDev) {
        this.robotDev = robotDev;
    }

    public VoiceDev getVoiceDev() {
        return voiceDev;
    }

    public void setVoiceDev(VoiceDev voiceDev) {
        this.voiceDev = voiceDev;
    }

    public MonitorDev getMonitorDev() {
        return monitorDev;
    }

    public void setMonitorDev(MonitorDev monitorDev) {
        this.monitorDev = monitorDev;
    }

    public IntercomPillarDev getIntercomPillarDev() {
        return intercomPillarDev;
    }

    public void setIntercomPillarDev(IntercomPillarDev intercomPillarDev) {
        this.intercomPillarDev = intercomPillarDev;
    }

    public static class MainCamera implements Serializable {
        /**
         * 设备编号编辑时必填）
         */
        private String deviceNo;

        /**
         * 主相机ip
         */
        private String ip;

        /**
         * 通讯方式（1:4G 2:有线）
         */
        private Integer linetype;

        /**
         * 主相机序列号
         */
        private String serialNumber;

        /**
         * 是否连接语音屏显（0：否，1：是）
         */
        private Integer isVoiceLed;

        /**
         * 是否连接道闸（0：否，1：是）
         */
        private Integer isParkGate;

        public String getDeviceNo() {
            return deviceNo;
        }

        public void setDeviceNo(String deviceNo) {
            this.deviceNo = deviceNo;
        }

        public String getIp() {
            return ip;
        }

        public void setIp(String ip) {
            this.ip = ip;
        }

        public Integer getLinetype() {
            return linetype;
        }

        public void setLinetype(Integer linetype) {
            this.linetype = linetype;
        }

        public String getSerialNumber() {
            return serialNumber;
        }

        public void setSerialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
        }

        public Integer getIsVoiceLed() {
            return isVoiceLed;
        }

        public void setIsVoiceLed(Integer isVoiceLed) {
            this.isVoiceLed = isVoiceLed;
        }

        public Integer getIsParkGate() {
            return isParkGate;
        }

        public void setIsParkGate(Integer isParkGate) {
            this.isParkGate = isParkGate;
        }
    }

    public static class SecoCamera implements Serializable {

        /**
         * 设备编号（编辑时必填）
         */
        private String deviceNo;

        /**
         * 辅相机ip
         */
        private String ip;

        /**
         * 通讯方式（1:4G 2:有线）
         */
        private Integer linetype;

        /**
         * 主相机序列号
         */
        private String serialNumber;

        /**
         * 是否连接语音屏显（0：否，1：是）
         */
        private Integer isVoiceLed;

        /**
         * 是否连接道闸(0：否，1：是)
         */
        private Integer isParkGate;

        public String getDeviceNo() {
            return deviceNo;
        }

        public void setDeviceNo(String deviceNo) {
            this.deviceNo = deviceNo;
        }

        public String getIp() {
            return ip;
        }

        public void setIp(String ip) {
            this.ip = ip;
        }

        public Integer getLinetype() {
            return linetype;
        }

        public void setLinetype(Integer linetype) {
            this.linetype = linetype;
        }

        public String getSerialNumber() {
            return serialNumber;
        }

        public void setSerialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
        }

        public Integer getIsVoiceLed() {
            return isVoiceLed;
        }

        public void setIsVoiceLed(Integer isVoiceLed) {
            this.isVoiceLed = isVoiceLed;
        }

        public Integer getIsParkGate() {
            return isParkGate;
        }

        public void setIsParkGate(Integer isParkGate) {
            this.isParkGate = isParkGate;
        }
    }

    public static class RobotDev implements Serializable {

        /**
         * 设备编号（编辑时必填）
         */
        private String deviceNo;

        /**
         * 机器人ip
         */
        private String ip;

        /**
         * 机器人端口号
         */
        private Integer port;

        public String getDeviceNo() {
            return deviceNo;
        }

        public void setDeviceNo(String deviceNo) {
            this.deviceNo = deviceNo;
        }

        public String getIp() {
            return ip;
        }

        public void setIp(String ip) {
            this.ip = ip;
        }

        public Integer getPort() {
            return port;
        }

        public void setPort(Integer port) {
            this.port = port;
        }
    }

    public static class VoiceDev implements Serializable {

        /**
         * 设备编号（编辑时必填）
         */
        private String deviceNo;

        /**
         * 监控相机序列号
         */
        private String serialNumber;

        public String getDeviceNo() {
            return deviceNo;
        }

        public void setDeviceNo(String deviceNo) {
            this.deviceNo = deviceNo;
        }

        public String getSerialNumber() {
            return serialNumber;
        }

        public void setSerialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
        }
    }

    public static class MonitorDev implements Serializable {

        /**
         * 设备编号（编辑时必填）
         */
        private String deviceNo;

        /**
         * 监控相机序列号
         */
        private String serialNumber;

        /**
         * 验证码
         */
        private String verCode;

        public String getDeviceNo() {
            return deviceNo;
        }

        public void setDeviceNo(String deviceNo) {
            this.deviceNo = deviceNo;
        }

        public String getSerialNumber() {
            return serialNumber;
        }

        public void setSerialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
        }

        public String getVerCode() {
            return verCode;
        }

        public void setVerCode(String verCode) {
            this.verCode = verCode;
        }
    }

    public static class IntercomPillarDev implements Serializable {

        /**
         * 设备编号（编辑时必填）
         */
        private String deviceNo;

        /**
         * 监控相机序列号
         */
        private String serialNumber;

        /**
         * 通讯方式 1:无线 2:有线3:wifi 4:相机485透传 
         */
        protected Integer callMethods;

        /**
         * ip
         */
        private String ip;

        public String getDeviceNo() {
            return deviceNo;
        }

        public void setDeviceNo(String deviceNo) {
            this.deviceNo = deviceNo;
        }

        public String getSerialNumber() {
            return serialNumber;
        }

        public void setSerialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
        }

        public Integer getCallMethods() {
            return callMethods;
        }

        public void setCallMethods(Integer callMethods) {
            this.callMethods = callMethods;
        }

        public String getIp() {
            return ip;
        }

        public void setIp(String ip) {
            this.ip = ip;
        }
    }

    @Override
    protected String method() {
        return "p2c.save.channel";
    }

    @Override
    protected void buildBizContent(Map<String, Object> bizContent) {
        super.buildBizContent(bizContent);
        bizContent.put("mainCamera", JSON.toJSON(getMainCamera()));
        bizContent.put("secoCamera", JSON.toJSON(getSecoCamera()));
        bizContent.put("robotDev", JSON.toJSON(getRobotDev()));
        bizContent.put("voiceDev", JSON.toJSON(getVoiceDev()));
        bizContent.put("monitorDev", JSON.toJSON(getMonitorDev()));
        bizContent.put("intercomPillarDev", JSON.toJSON(getIntercomPillarDev()));
    }

}
