package com.icetech.sdk.request.p2c.base;

import com.icetech.sdk.request.BaseRequest;
import com.icetech.sdk.response.p2c.base.P2cRegionListResponse;

/**
 * The type P 2 c region list request.
 *
 * @author fangct
 */
public class P2cRegionListRequest extends BaseRequest<P2cRegionListResponse> {

    /**
     * 停车场编号（系统自动生成）
     */
    private String parkCode;

    /**
     * 分页查询页码（默认1,每页10条）
     */
    private Integer pageNo;

    /**
     * 分页查询单页数量（默认20 小于1000）
     */
    private Integer pageSize;

    /**
     * Gets park code.
     *
     * @return the park code
     */
    public String getParkCode() {
        return parkCode;
    }

    /**
     * Sets park code.
     *
     * @param parkCode the park code
     */
    public void setParkCode(String parkCode) {
        this.parkCode = parkCode;
    }

    /**
     * Gets page no.
     *
     * @return the page no
     */
    public Integer getPageNo() {
        return pageNo;
    }

    /**
     * Sets page no.
     *
     * @param pageNo the page no
     */
    public void setPageNo(Integer pageNo) {
        this.pageNo = pageNo;
    }

    /**
     * Gets page size.
     *
     * @return the page size
     */
    public Integer getPageSize() {
        return pageSize;
    }

    /**
     * Sets page size.
     *
     * @param pageSize the page size
     */
    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    @Override
    protected String method() {
        return "p2c.region.list";
    }
}
