package com.icetech.sdk.request.p2c.base;

import com.icetech.sdk.request.BaseRequest;
import com.icetech.sdk.response.p2c.base.P2cParkListResponse;

/**
 * Description ParkListRequest
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2022/7/8 11:37
 */
public class P2cParkListRequest extends BaseRequest<P2cParkListResponse> {

    /**
     * 当前加载的页码 默认加载第一页
     */
    private Integer pageNo;

    /**
     * 每页显示的记录数
     */
    private Integer pageSize;

    public Integer getPageNo() {
        return pageNo;
    }

    public void setPageNo(Integer pageNo) {
        this.pageNo = pageNo;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    @Override
    protected String method() {
        return "p2c.park.list";
    }

}
