package com.icetech.sdk.request.p2c.base;

import com.icetech.sdk.request.BaseRequest;
import com.icetech.sdk.response.p2c.base.P2cParkChannelListResponse;

/**
 * Description P2cParkChannelListRequest
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2022/7/8 11:37
 */
public class P2cParkChannelListRequest extends BaseRequest<P2cParkChannelListResponse> {

    /**
     * 车场编号
     */
    private String parkCode;

    /**
     * 当前加载的页码 默认加载第一页
     */
    private Integer pageNo;

    /**
     * 每页显示的记录数
     */
    private Integer pageSize;

    public Integer getPageNo() {
        return pageNo;
    }

    public void setPageNo(Integer pageNo) {
        this.pageNo = pageNo;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getParkCode() {
        return parkCode;
    }

    public void setParkCode(String parkCode) {
        this.parkCode = parkCode;
    }

    @Override
    protected String method() {
        return "p2c.park.channel.list";
    }

}
