package com.icetech.sdk.request.p2c.base;

import com.icetech.sdk.request.BaseRequest;
import com.icetech.sdk.response.p2c.base.P2cExitSyncResponse;


/**
 * 入场数据同步
 * @author wangzhiwei
 */
public class P2cExitSyncRequest extends BaseRequest<P2cExitSyncResponse> {

    /**
     * 车场编号
     */
    private String parkCode;
    /**
     * 通道编号
     */
    private String channelCode;
    /**
     * 车牌号
     */
    private String plateNum;
    /**
     * 出场时间，UNIX时间戳
     */
    private Long exitTime;
    /**
     * 支付金额 单位 元
     */
    private String paidPrice;
    /**
     * 支付方式
     */
    private Integer payWay;


    public String getParkCode() {
        return parkCode;
    }

    public void setParkCode(String parkCode) {
        this.parkCode = parkCode;
    }

    public String getChannelCode() {
        return channelCode;
    }

    public void setChannelCode(String channelCode) {
        this.channelCode = channelCode;
    }

    public String getPlateNum() {
        return plateNum;
    }

    public void setPlateNum(String plateNum) {
        this.plateNum = plateNum;
    }

    public Long getExitTime() {
        return exitTime;
    }

    public void setExitTime(Long exitTime) {
        this.exitTime = exitTime;
    }

    public String getPaidPrice() {
        return paidPrice;
    }

    public void setPaidPrice(String paidPrice) {
        this.paidPrice = paidPrice;
    }

    public Integer getPayWay() {
        return payWay;
    }

    public void setPayWay(Integer payWay) {
        this.payWay = payWay;
    }

    @Override
    protected String method() {
        return "p2c.sync.exit";
    }

}
