package com.icetech.sdk.request.p2c.base;

import com.icetech.sdk.request.BaseRequest;
import com.icetech.sdk.response.p2c.base.P2cEnterSyncResponse;
import com.icetech.sdk.response.p2c.business.P2cDelMonthCardResponse;


/**
 * 入场数据同步
 * @author wangzhiwei
 */
public class P2cEnterSyncRequest extends BaseRequest<P2cEnterSyncResponse> {

    /**
     * 车场编号
     */
    private String parkCode;

    /**
     * 通道编号
     */
    private String channelCode;
    /**
     * 车牌号
     */
    private String plateNum;
    /**
     * 入场时间，UNIX时间戳
     */
    private Long enterTime;


    public String getParkCode() {
        return parkCode;
    }

    public void setParkCode(String parkCode) {
        this.parkCode = parkCode;
    }

    public String getChannelCode() {
        return channelCode;
    }

    public void setChannelCode(String channelCode) {
        this.channelCode = channelCode;
    }

    public String getPlateNum() {
        return plateNum;
    }

    public void setPlateNum(String plateNum) {
        this.plateNum = plateNum;
    }

    public Long getEnterTime() {
        return enterTime;
    }

    public void setEnterTime(Long enterTime) {
        this.enterTime = enterTime;
    }

    @Override
    protected String method() {
        return "p2c.sync.enter";
    }

}
