package com.icetech.sdk.request.p2c.base;

import com.alibaba.fastjson.JSON;
import com.icetech.sdk.request.BaseRequest;
import com.icetech.sdk.response.p2c.base.P2cEditParkRegionResponse;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * Description EditParkRegionRequest
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2022/7/18 11:32
 */
public class P2cEditParkRegionRequest extends BaseRequest<P2cEditParkRegionResponse> {

    /**
     * 分区编号（长度6-32位，全平台唯一）
     */
    private String regionCode;

    /**
     * 停车场编号
     */
    private String parkCode;

    /**
     * 区域名称
     */
    private String regionName;

    /**
     * 区域泊位总数
     */
    private Integer regionPark;

    /**
     * 计费规则编号（从计费规则列表接口中获取或者不传此参数，会使用车场默认计费规则）
     */
    private String billtypecode;

    /**
     * 是否有子区域 1：有 2：无
     */
    private Integer hasInner;

    /**
     * 子区域数据 hasInner==1是此参数必填
     */
    private List<SonData> sonData;

    /**
     * Gets region code.
     *
     * @return the region code
     */
    public String getRegionCode() {
        return regionCode;
    }

    /**
     * Sets region code.
     *
     * @param regionCode the region code
     */
    public void setRegionCode(String regionCode) {
        this.regionCode = regionCode;
    }

    /**
     * Gets park code.
     *
     * @return the park code
     */
    public String getParkCode() {
        return parkCode;
    }

    /**
     * Sets park code.
     *
     * @param parkCode the park code
     */
    public void setParkCode(String parkCode) {
        this.parkCode = parkCode;
    }

    /**
     * Gets region name.
     *
     * @return the region name
     */
    public String getRegionName() {
        return regionName;
    }

    /**
     * Sets region name.
     *
     * @param regionName the region name
     */
    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    /**
     * Gets region park.
     *
     * @return the region park
     */
    public Integer getRegionPark() {
        return regionPark;
    }

    /**
     * Sets region park.
     *
     * @param regionPark the region park
     */
    public void setRegionPark(Integer regionPark) {
        this.regionPark = regionPark;
    }

    /**
     * Gets billtypecode.
     *
     * @return the billtypecode
     */
    public String getBilltypecode() {
        return billtypecode;
    }

    /**
     * Sets billtypecode.
     *
     * @param billtypecode the billtypecode
     */
    public void setBilltypecode(String billtypecode) {
        this.billtypecode = billtypecode;
    }

    /**
     * Gets has inner.
     *
     * @return the has inner
     */
    public Integer getHasInner() {
        return hasInner;
    }

    /**
     * Sets has inner.
     *
     * @param hasInner the has inner
     */
    public void setHasInner(Integer hasInner) {
        this.hasInner = hasInner;
    }

    /**
     * Gets son data.
     *
     * @return the son data
     */
    public List<SonData> getSonData() {
        return sonData;
    }

    /**
     * Sets son data.
     *
     * @param sonData the son data
     */
    public void setSonData(List<SonData> sonData) {
        this.sonData = sonData;
    }

    /**
     * The type Son data.
     */
    public static class SonData implements Serializable {

        /**
         * 子区域名称
         */
        private String regionName;

        /**
         * 子分区编号（长度6-32位，全平台唯一）
         */
        private String regionCode;

        /**
         * 子区域泊位总数
         */
        private Integer regionPark;

        /**
         * 子区域计费规则编号（从计费规则列表接口中获取或者不传此参数，会使用车场默认计费规则）
         */
        private String billtypecode;

        /**
         * Gets region name.
         *
         * @return the region name
         */
        public String getRegionName() {
            return regionName;
        }

        /**
         * Sets region name.
         *
         * @param regionName the region name
         */
        public void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        /**
         * Gets region code.
         *
         * @return the region code
         */
        public String getRegionCode() {
            return regionCode;
        }

        /**
         * Sets region code.
         *
         * @param regionCode the region code
         */
        public void setRegionCode(String regionCode) {
            this.regionCode = regionCode;
        }

        /**
         * Gets region park.
         *
         * @return the region park
         */
        public Integer getRegionPark() {
            return regionPark;
        }

        /**
         * Sets region park.
         *
         * @param regionPark the region park
         */
        public void setRegionPark(Integer regionPark) {
            this.regionPark = regionPark;
        }

        /**
         * Gets billtypecode.
         *
         * @return the billtypecode
         */
        public String getBilltypecode() {
            return billtypecode;
        }

        /**
         * Sets billtypecode.
         *
         * @param billtypecode the billtypecode
         */
        public void setBilltypecode(String billtypecode) {
            this.billtypecode = billtypecode;
        }
    }

    @Override
    protected String method() {
        return "p2c.edit.park.region";
    }

    @Override
    protected void buildBizContent(Map<String, Object> bizContent) {
        super.buildBizContent(bizContent);
        bizContent.put("sonData", JSON.toJSON(getSonData()));
    }
}
