package com.icetech.sdk.request.p2c.base;

import com.icetech.sdk.request.BaseRequest;
import com.icetech.sdk.response.p2c.base.P2cDeviceListResponse;

/**
 * Description P2cDeviceListRequest
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2022/7/8 11:37
 */
public class P2cDeviceListRequest extends BaseRequest<P2cDeviceListResponse> {
    /**
     * 停车场编号
     */
    private String parkCode;

    /**
     * 设备状态 0未连接，1在线，2离线
     */
    private Integer deviceStatus;

    /**
     * 当前加载的页码 默认加载第一页
     */
    private Integer pageNo;

    /**
     * 每页显示的记录数
     */
    private Integer pageSize;

    public String getParkCode() {
        return parkCode;
    }

    public void setParkCode(String parkCode) {
        this.parkCode = parkCode;
    }

    public Integer getDeviceStatus() {
        return deviceStatus;
    }

    public void setDeviceStatus(Integer deviceStatus) {
        this.deviceStatus = deviceStatus;
    }

    public Integer getPageNo() {
        return pageNo;
    }

    public void setPageNo(Integer pageNo) {
        this.pageNo = pageNo;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    @Override
    protected String method() {
        return "p2c.device.list";
    }

}
