package com.icetech.sdk.request.p2c.base;

import com.icetech.sdk.request.BaseRequest;
import com.icetech.sdk.response.p2c.base.P2cDelRegionResponse;

/**
 * Description P2cDelRegionRequest
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2022/7/18 14:11
 */
public class P2cDelRegionRequest extends BaseRequest<P2cDelRegionResponse> {

    /**
     * 分区编号（长度6-32位，全平台唯一）
     */
    private String regionCode;

    /**
     * 停车场编号
     */
    private String parkCode;

    /**
     * Gets region code.
     *
     * @return the region code
     */
    public String getRegionCode() {
        return regionCode;
    }

    /**
     * Sets region code.
     *
     * @param regionCode the region code
     */
    public void setRegionCode(String regionCode) {
        this.regionCode = regionCode;
    }

    /**
     * Gets park code.
     *
     * @return the park code
     */
    public String getParkCode() {
        return parkCode;
    }

    /**
     * Sets park code.
     *
     * @param parkCode the park code
     */
    public void setParkCode(String parkCode) {
        this.parkCode = parkCode;
    }

    @Override
    protected String method() {
        return "p2c.del.park.region";
    }
}
