package com.icetech.sdk.request.itc;

import com.icetech.sdk.request.BaseRequest;
import com.icetech.sdk.response.itc.ItcPayCodeNotifyResponse;

/**
 * Description ItcPayCodeNotifyRequeset
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2023/9/14 11:25
 */
public class ItcPayCodeNotifyRequest extends BaseRequest<ItcPayCodeNotifyResponse> {

    /**
     * 设备序列号
     */
    private String sn;

    /**
     * 车场编码
     */
    private String payCode;

    /**
     * 扫码时间，10 位时间戳
     */
    private Long scanTime;

    public String getSn() {
        return sn;
    }

    public void setSn(String sn) {
        this.sn = sn;
    }

    public String getPayCode() {
        return payCode;
    }

    public void setPayCode(String payCode) {
        this.payCode = payCode;
    }

    public Long getScanTime() {
        return scanTime;
    }

    public void setScanTime(Long scanTime) {
        this.scanTime = scanTime;
    }

    @Override
    protected String method() {
        return "itc.pay.code.msg";
    }
}
