package com.icetech.sdk.request.itc;

import com.icetech.sdk.request.BaseRequest;
import com.icetech.sdk.response.BaseResponse;

/**
 * Description ItcHintRequest
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2023/9/14 16:26
 */
public class ItcHintRequest extends BaseRequest<BaseResponse> {

    /**
     * 设备序列号
     */
    private String sn;

    /**
     * 场景
     */
    private Integer scene;

    /**
     * 车牌号
     */
    private String plateNum;

    /**
     * 显示播报的车辆类型，默认为临时车；此处的类型为显示播报类型
     */
    private Integer type;

    /**
     * VIP车辆类型名称
     */
    private String vipTypeName;

    /**
     * 月卡车的剩余天数
     */
    private Integer remainDaysMc;

    /**
     * 剩余车位数
     */
    private Integer freeSpace;

    /**
     * 停车时长，单位秒
     */
    private Long parkTime;

    /**
     * 停车费，单位分；出场需缴费场景下必传
     */
    private Integer unpayPrice;

    /**
     * 二维码URL地址
     */
    private String qrCodeUrl;

    public String getSn() {
        return sn;
    }

    public void setSn(String sn) {
        this.sn = sn;
    }

    public Integer getScene() {
        return scene;
    }

    public void setScene(Integer scene) {
        this.scene = scene;
    }

    public String getPlateNum() {
        return plateNum;
    }

    public void setPlateNum(String plateNum) {
        this.plateNum = plateNum;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getVipTypeName() {
        return vipTypeName;
    }

    public void setVipTypeName(String vipTypeName) {
        this.vipTypeName = vipTypeName;
    }

    public Integer getRemainDaysMc() {
        return remainDaysMc;
    }

    public void setRemainDaysMc(Integer remainDaysMc) {
        this.remainDaysMc = remainDaysMc;
    }

    public Integer getFreeSpace() {
        return freeSpace;
    }

    public void setFreeSpace(Integer freeSpace) {
        this.freeSpace = freeSpace;
    }

    public Long getParkTime() {
        return parkTime;
    }

    public void setParkTime(Long parkTime) {
        this.parkTime = parkTime;
    }

    public Integer getUnpayPrice() {
        return unpayPrice;
    }

    public void setUnpayPrice(Integer unpayPrice) {
        this.unpayPrice = unpayPrice;
    }

    public String getQrCodeUrl() {
        return qrCodeUrl;
    }

    public void setQrCodeUrl(String qrCodeUrl) {
        this.qrCodeUrl = qrCodeUrl;
    }

    @Override
    protected String method() {
        return "itc.hint";
    }
}
