package com.icetech.sdk.request.iot;
import com.icetech.sdk.request.BaseRequest;
import com.icetech.sdk.response.iot.AntiDiversionLockResponse;
import com.icetech.sdk.util.StringUtils;

import java.util.StringJoiner;

public class AntiDiversionLockRequest extends BaseRequest<AntiDiversionLockResponse> {

    @Override
    protected String method() {
        return "ice.device.anti-diversion-lock";
    }

    private String deviceCode;

    private Integer status;


    public String getDeviceCode() {
        return deviceCode;
    }

    public void setDeviceCode(String deviceCode) {
        if (StringUtils.isEmpty(deviceCode)) {
            throw new IllegalArgumentException("deviceCode can't be empty");
        }
        this.deviceCode = deviceCode;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public AntiDiversionLockRequest() {
    }

    public AntiDiversionLockRequest(String deviceCode, Integer status) {
        this.deviceCode = deviceCode;
        this.status = status;
    }

    public AntiDiversionLockRequest(String method, String version, String deviceCode, Integer status) {
        super(method, version);
        this.deviceCode = deviceCode;
        this.status = status;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", AntiDiversionLockRequest.class.getSimpleName() + "[", "]")
                .add("deviceCode='" + deviceCode + "'")
                .add("status=" + status)
                .toString();
    }
}
