package com.icetech.sdk.request.iot;

import com.icetech.sdk.request.BaseRequest;
import com.icetech.sdk.response.iot.AntiDiversionConfigResponse;
import com.icetech.sdk.util.StringUtils;

import java.util.Objects;
import java.util.StringJoiner;

public class AntiDiversionConfigRequest extends BaseRequest<AntiDiversionConfigResponse> {

    @Override
    protected String method() {
        return "ice.device.anti-diversion-config";
    }

    private String deviceCode;

    private String region;//区域,

    private String platePrefix;//车牌前缀 京A,京 多个车牌前缀用,分割

    private Integer nonRegionPercentage;//50 非区域车牌百分比

    private Integer statisticsBase;//统计基数

    private String notifyUrl;//通知地址 https://xxx.xx.xxx

    private Integer status;//设备状态 0=正常,1=锁定


    public String getDeviceCode() {
        return deviceCode;
    }

    public void setDeviceCode(String deviceCode) {
        if (StringUtils.isEmpty(deviceCode)) {
            throw new IllegalArgumentException("deviceCode can't be empty");
        }
        this.deviceCode = deviceCode;
    }

    public String getRegion() {
        return region;
    }

    public void setRegion(String region) {
        if (StringUtils.isEmpty(region)) {
            throw new IllegalArgumentException("region can't be empty");
        }
        this.region = region;
    }

    public String getPlatePrefix() {
        return platePrefix;
    }

    public void setPlatePrefix(String platePrefix) {
        if (StringUtils.isEmpty(platePrefix)) {
            throw new IllegalArgumentException("platePrefix can't be empty");
        }
        this.platePrefix = platePrefix;
    }

    public Integer getNonRegionPercentage() {
        return nonRegionPercentage;
    }

    public void setNonRegionPercentage(Integer nonRegionPercentage) {
        if (Objects.isNull(nonRegionPercentage)) {
            throw new IllegalArgumentException("nonRegionPercentage can't be empty");
        }
        this.nonRegionPercentage = nonRegionPercentage;
    }

    public Integer getStatisticsBase() {
        return statisticsBase;
    }

    public void setStatisticsBase(Integer statisticsBase) {
        if (Objects.isNull(statisticsBase)) {
            throw new IllegalArgumentException("statisticsBase can't be empty");
        }
        this.statisticsBase = statisticsBase;
    }

    public String getNotifyUrl() {
        return notifyUrl;
    }

    public void setNotifyUrl(String notifyUrl) {
        if (Objects.isNull(notifyUrl)) {
            throw new IllegalArgumentException("notifyUrl can't be empty");
        }
        this.notifyUrl = notifyUrl;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", AntiDiversionConfigRequest.class.getSimpleName() + "[", "]")
                .add("deviceCode='" + deviceCode + "'")
                .add("region='" + region + "'")
                .add("platePrefix='" + platePrefix + "'")
                .add("nonRegionPercentage=" + nonRegionPercentage)
                .add("statisticsBase=" + statisticsBase)
                .add("notifyUrl='" + notifyUrl + "'")
                .add("status=" + status)
                .toString();
    }
}
