package com.icetech.sdk.request;

import java.io.Serializable;
import java.util.List;

/**
 * Description TwentyFourHourChargeRule
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2022/7/24 6:57 下午
 */
public class TwentyFourHourChargeRule implements Serializable {

    /**
     * 免费时长（分钟）
     */
    private Integer freetime;

    /**
     * 累计24小时免费时长是否使用多次 （1：24小时免费时长可用一次，2：每次进场都可用 ，默认2）
     */
    private Integer isFreetimeOnce;

    /**
     * 是否使用一天最大收费限额(一天) 0：禁用 1：启用 默认为0
     */
    private Integer daynightmaxfeeusing;

    /**
     * 最大收费限额类型1=单天单次最高收费 2=单天最高收费 3=24小时最高收费
     */
    private Integer daynightmaxfeetype;

    /**
     * 24小时统计方式 1=以24小时内的订单入场时间为准 2=以24小时之内的出场时间判断
     */
    private Integer daynightmaxfeecounttype;

    /**
     * 小型车单天最高收费金额，单位元
     */
    private String daynightmaxfee;

    /**
     * 大型车单天最高收费金额，单位元
     */
    private String daynightmaxfeeBig;

    /**
     * 时间分割分钟数，（只能是30或60）单位分钟，会将一天24小时按分割分钟数等额平均分开来设置计费
     */
    private Integer divisionTime;

    /**
     * 是否启用跨天后收费， 1：是， 2：否， 默认为2
     */
    private Integer isOverTimeSet;

    /**
     * 跨天后每间隔多长时间，单位分钟
     */
    private Integer feespantimestep;

    /**
     * 小型车跨天后单位费用，单位元
     */
    private String feespanratestep;

    /**
     * 大型车跨天后单位费用，单位元
     */
    private String feespanratestepBig;

    /**
     * 是否区分大小型车计费（0：否，1：是）
     */
    private Integer isSmallbigcarSet;

    /**
     * 24小时计费详情
     */
    private List<TwentyFourHourChargeRuleDetails> details;

    public Integer getFreetime() {
        return freetime;
    }

    public void setFreetime(Integer freetime) {
        this.freetime = freetime;
    }

    public Integer getIsFreetimeOnce() {
        return isFreetimeOnce;
    }

    public void setIsFreetimeOnce(Integer isFreetimeOnce) {
        this.isFreetimeOnce = isFreetimeOnce;
    }

    public Integer getDaynightmaxfeeusing() {
        return daynightmaxfeeusing;
    }

    public void setDaynightmaxfeeusing(Integer daynightmaxfeeusing) {
        this.daynightmaxfeeusing = daynightmaxfeeusing;
    }

    public Integer getDaynightmaxfeetype() {
        return daynightmaxfeetype;
    }

    public void setDaynightmaxfeetype(Integer daynightmaxfeetype) {
        this.daynightmaxfeetype = daynightmaxfeetype;
    }

    public Integer getDaynightmaxfeecounttype() {
        return daynightmaxfeecounttype;
    }

    public void setDaynightmaxfeecounttype(Integer daynightmaxfeecounttype) {
        this.daynightmaxfeecounttype = daynightmaxfeecounttype;
    }

    public String getDaynightmaxfee() {
        return daynightmaxfee;
    }

    public void setDaynightmaxfee(String daynightmaxfee) {
        this.daynightmaxfee = daynightmaxfee;
    }

    public String getDaynightmaxfeeBig() {
        return daynightmaxfeeBig;
    }

    public void setDaynightmaxfeeBig(String daynightmaxfeeBig) {
        this.daynightmaxfeeBig = daynightmaxfeeBig;
    }

    public Integer getDivisionTime() {
        return divisionTime;
    }

    public void setDivisionTime(Integer divisionTime) {
        this.divisionTime = divisionTime;
    }

    public Integer getIsOverTimeSet() {
        return isOverTimeSet;
    }

    public void setIsOverTimeSet(Integer isOverTimeSet) {
        this.isOverTimeSet = isOverTimeSet;
    }

    public Integer getFeespantimestep() {
        return feespantimestep;
    }

    public void setFeespantimestep(Integer feespantimestep) {
        this.feespantimestep = feespantimestep;
    }

    public String getFeespanratestep() {
        return feespanratestep;
    }

    public void setFeespanratestep(String feespanratestep) {
        this.feespanratestep = feespanratestep;
    }

    public String getFeespanratestepBig() {
        return feespanratestepBig;
    }

    public void setFeespanratestepBig(String feespanratestepBig) {
        this.feespanratestepBig = feespanratestepBig;
    }

    public Integer getIsSmallbigcarSet() {
        return isSmallbigcarSet;
    }

    public void setIsSmallbigcarSet(Integer isSmallbigcarSet) {
        this.isSmallbigcarSet = isSmallbigcarSet;
    }

    public List<TwentyFourHourChargeRuleDetails> getDetails() {
        return details;
    }

    public void setDetails(List<TwentyFourHourChargeRuleDetails> details) {
        this.details = details;
    }

    public static class TwentyFourHourChargeRuleDetails implements Serializable {

        /**
         * 型车单位费用，单位元
         */
        private String feespanrateBig;

        /**
         * 小型车单位费用，单位元
         */
        private String feespanrate;

        /**
         * 计费时间点，单位分钟；如1.5小时，此值为90
         */
        private Integer feespantime;

        public String getFeespanrateBig() {
            return feespanrateBig;
        }

        public void setFeespanrateBig(String feespanrateBig) {
            this.feespanrateBig = feespanrateBig;
        }

        public String getFeespanrate() {
            return feespanrate;
        }

        public void setFeespanrate(String feespanrate) {
            this.feespanrate = feespanrate;
        }

        public Integer getFeespantime() {
            return feespantime;
        }

        public void setFeespantime(Integer feespantime) {
            this.feespantime = feespantime;
        }
    }
}
