package com.icetech.sdk.request;

import com.icetech.sdk.response.RemoteSwitchResponse;

import java.util.Map;

/**
 * Description IceVideoLiveUrlRequest
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2022/4/12 10:35
 */
public class RemoteSwitchRequest extends BaseRequest<RemoteSwitchResponse> {

    /**
     * 设备编号
     */
    private String sn;
    /**
     * 开关闸类型，1：开闸，0：关闸
     */
    private Integer switchType;

    public Integer getSwitchType() {
        return switchType;
    }

    public void setSwitchType(Integer switchType) {
        this.switchType = switchType;
    }

    public String getSn() {
        return sn;
    }

    public void setSn(String sn) {
        this.sn = sn;
    }

    @Override
    protected String method() {
        return "p2p.remote.switch";
    }

    @Override
    protected void buildBizContent(Map<String, Object> bizContent) {
        bizContent.put("sn", getSn());
        bizContent.put("switchType", getSwitchType());
    }
}
