package com.icetech.sdk.request;

import java.io.Serializable;

/**
 * Description DayNightChargeRule
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2022/7/24 6:42 下午
 */
public class DayNightChargeRule implements Serializable {

    /**
     * 免费时长（分钟）
     */
    private Integer freetime;

    /**
     * 累计24小时免费时长是否使用多次 （1：24小时免费时长可用一次，2：每次进场都可用 ，默认2）
     */
    private Integer isFreetimeOnce;

    /**
     * 是否使用一天最大收费限额(一天) 0：禁用 1：启用 默认为0
     */
    private Integer daynightmaxfeeusing;

    /**
     * 最大收费限额类型1=单天单次最高收费 2=单天最高收费 3=24小时最高收费
     */
    private Integer daynightmaxfeetype;

    /**
     * 24小时统计方式 1=以24小时内的订单入场时间为准 2=以24小时之内的出场时间判断
     */
    private Integer daynightmaxfeecounttype;

    /**
     * 小型车单天最高收费金额，单位元
     */
    private String daynightmaxfee;

    /**
     * 大型车单天最高收费金额，单位元
     */
    private String daynightmaxfeeBig;

    /**
     * 白天开始计费时间，0点到开始时间的分钟数；例如早上8点钟为8 * 60 = 480
     */
    private Integer daybegin;

    /**
     * 晚上开始计费时间，0点到开始时间的分钟数；例如晚上8点钟为20 * 60 = 1200
     */
    private Integer nightbegin;

    /**
     * 是否启用白天最大收费， 1：是 2：否, 默认为2
     */
    private Integer daymaxfeeusing;

    /**
     * 小型车白天最大收费金额，单位元
     */
    private String daymaxfee;

    /**
     * 大型车白天最大收费金额，单位元
     */
    private String daymaxfeeBig;

    /**
     * 是否启用夜间最大收费， 1：是， 2：否 ，默认为2
     */
    private Integer nightmaxfeeusing;

    /**
     * 小型车夜间最大收费金额，单位元
     */
    private String nightmaxfee;

    /**
     * 大型车白天最大收费金额，单位元
     */
    private String nightmaxfeeBig;

    /**
     * 白天计费方式，1：按次计费 2：按停车时长计费
     */
    private Integer dayBillmethod;

    /**
     * 夜间计费方式，1：按次计费 2：按停车时长计费
     */
    private Integer nightBillmethod;

    /**
     * 是否区分大小型车计费（0：否，1：是）
     */
    private Integer isSmallbigcarSet;

    /**
     * 白天计费配置，请根据计费方式，查看具体的参数说明
     */
    private ChargeMethodConfig dayConfig;

    /**
     * 夜间计费配置，请根据计费方式，查看具体的参数说明
     */
    private ChargeMethodConfig nightConfig;

    public Integer getFreetime() {
        return freetime;
    }

    public void setFreetime(Integer freetime) {
        this.freetime = freetime;
    }

    public Integer getIsFreetimeOnce() {
        return isFreetimeOnce;
    }

    public void setIsFreetimeOnce(Integer isFreetimeOnce) {
        this.isFreetimeOnce = isFreetimeOnce;
    }

    public Integer getDaynightmaxfeeusing() {
        return daynightmaxfeeusing;
    }

    public void setDaynightmaxfeeusing(Integer daynightmaxfeeusing) {
        this.daynightmaxfeeusing = daynightmaxfeeusing;
    }

    public Integer getDaynightmaxfeetype() {
        return daynightmaxfeetype;
    }

    public void setDaynightmaxfeetype(Integer daynightmaxfeetype) {
        this.daynightmaxfeetype = daynightmaxfeetype;
    }

    public Integer getDaynightmaxfeecounttype() {
        return daynightmaxfeecounttype;
    }

    public void setDaynightmaxfeecounttype(Integer daynightmaxfeecounttype) {
        this.daynightmaxfeecounttype = daynightmaxfeecounttype;
    }

    public String getDaynightmaxfee() {
        return daynightmaxfee;
    }

    public void setDaynightmaxfee(String daynightmaxfee) {
        this.daynightmaxfee = daynightmaxfee;
    }

    public String getDaynightmaxfeeBig() {
        return daynightmaxfeeBig;
    }

    public void setDaynightmaxfeeBig(String daynightmaxfeeBig) {
        this.daynightmaxfeeBig = daynightmaxfeeBig;
    }

    public Integer getDaybegin() {
        return daybegin;
    }

    public void setDaybegin(Integer daybegin) {
        this.daybegin = daybegin;
    }

    public Integer getNightbegin() {
        return nightbegin;
    }

    public void setNightbegin(Integer nightbegin) {
        this.nightbegin = nightbegin;
    }

    public Integer getDaymaxfeeusing() {
        return daymaxfeeusing;
    }

    public void setDaymaxfeeusing(Integer daymaxfeeusing) {
        this.daymaxfeeusing = daymaxfeeusing;
    }

    public String getDaymaxfee() {
        return daymaxfee;
    }

    public void setDaymaxfee(String daymaxfee) {
        this.daymaxfee = daymaxfee;
    }

    public String getDaymaxfeeBig() {
        return daymaxfeeBig;
    }

    public void setDaymaxfeeBig(String daymaxfeeBig) {
        this.daymaxfeeBig = daymaxfeeBig;
    }

    public Integer getNightmaxfeeusing() {
        return nightmaxfeeusing;
    }

    public void setNightmaxfeeusing(Integer nightmaxfeeusing) {
        this.nightmaxfeeusing = nightmaxfeeusing;
    }

    public String getNightmaxfee() {
        return nightmaxfee;
    }

    public void setNightmaxfee(String nightmaxfee) {
        this.nightmaxfee = nightmaxfee;
    }

    public String getNightmaxfeeBig() {
        return nightmaxfeeBig;
    }

    public void setNightmaxfeeBig(String nightmaxfeeBig) {
        this.nightmaxfeeBig = nightmaxfeeBig;
    }

    public Integer getDayBillmethod() {
        return dayBillmethod;
    }

    public void setDayBillmethod(Integer dayBillmethod) {
        this.dayBillmethod = dayBillmethod;
    }

    public Integer getNightBillmethod() {
        return nightBillmethod;
    }

    public void setNightBillmethod(Integer nightBillmethod) {
        this.nightBillmethod = nightBillmethod;
    }

    public Integer getIsSmallbigcarSet() {
        return isSmallbigcarSet;
    }

    public void setIsSmallbigcarSet(Integer isSmallbigcarSet) {
        this.isSmallbigcarSet = isSmallbigcarSet;
    }

    public ChargeMethodConfig getDayConfig() {
        return dayConfig;
    }

    public void setDayConfig(ChargeMethodConfig dayConfig) {
        this.dayConfig = dayConfig;
    }

    public ChargeMethodConfig getNightConfig() {
        return nightConfig;
    }

    public void setNightConfig(ChargeMethodConfig nightConfig) {
        this.nightConfig = nightConfig;
    }
}
