package com.icetech.sdk.request;

import java.io.Serializable;

/**
 * Description CurrencyChargeRule
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2022/7/24 6:36 下午
 */
public class CurrencyChargeRule implements Serializable {

    /**
     * 免费时长（分钟）
     */
    private Integer freetime;

    /**
     * 累计24小时免费时长是否使用多次 （1：24小时免费时长可用一次，2：每次进场都可用 ，默认2）
     */
    private Integer isFreetimeOnce;

    /**
     * 是否使用一天最大收费限额(一天) 0：禁用 1：启用 默认为0
     */
    private Integer daynightmaxfeeusing;

    /**
     * 最大收费限额类型1=单天单次最高收费 2=单天最高收费 3=24小时最高收费
     */
    private Integer daynightmaxfeetype;

    /**
     * 24小时统计方式 1=以24小时内的订单入场时间为准 2=以24小时之内的出场时间判断
     */
    private Integer daynightmaxfeecounttype;

    /**
     * 小型车单天最高收费金额，单位元
     */
    private String daynightmaxfee;

    /**
     * 大型车单天最高收费金额，单位元
     */
    private String daynightmaxfeeBig;

    /**
     * 是否区分工作日非工作日计费， 1：是 2：否，默认为2
     */
    private Integer isspecialdaycharge;

    /**
     * 通用计费方式或工作日计费方式，1：按次计费 2：按停车时长计费，不区分时工作日非工作日时，此为通用计费配置，区分时，此为工作日计费方式
     */
    private Integer oneBillmethod;

    /**
     * 非工作日计费方式，1：按次计费 2：按停车时长计费
     */
    private Integer twoBillmethod;

    /**
     * 是否区分大小型车计费（0：否，1：是）
     */
    private Integer isSmallbigcarSet;

    /**
     * 不区分时，此为通用计费配置，区分时，此为工作日计费配置，请根据计费方式，查看具体的参数说明
     */
    private ChargeMethodConfig firstConfig;

    /**
     * 非工作日计费配置，不区分工作日非工作日时，该参数不传；请根据计费方式，查看具体的参数说明
     */
    private ChargeMethodConfig twoConfig;

    public Integer getFreetime() {
        return freetime;
    }

    public void setFreetime(Integer freetime) {
        this.freetime = freetime;
    }

    public Integer getIsFreetimeOnce() {
        return isFreetimeOnce;
    }

    public void setIsFreetimeOnce(Integer isFreetimeOnce) {
        this.isFreetimeOnce = isFreetimeOnce;
    }

    public Integer getDaynightmaxfeeusing() {
        return daynightmaxfeeusing;
    }

    public void setDaynightmaxfeeusing(Integer daynightmaxfeeusing) {
        this.daynightmaxfeeusing = daynightmaxfeeusing;
    }

    public Integer getDaynightmaxfeetype() {
        return daynightmaxfeetype;
    }

    public void setDaynightmaxfeetype(Integer daynightmaxfeetype) {
        this.daynightmaxfeetype = daynightmaxfeetype;
    }

    public Integer getDaynightmaxfeecounttype() {
        return daynightmaxfeecounttype;
    }

    public void setDaynightmaxfeecounttype(Integer daynightmaxfeecounttype) {
        this.daynightmaxfeecounttype = daynightmaxfeecounttype;
    }

    public String getDaynightmaxfee() {
        return daynightmaxfee;
    }

    public void setDaynightmaxfee(String daynightmaxfee) {
        this.daynightmaxfee = daynightmaxfee;
    }

    public String getDaynightmaxfeeBig() {
        return daynightmaxfeeBig;
    }

    public void setDaynightmaxfeeBig(String daynightmaxfeeBig) {
        this.daynightmaxfeeBig = daynightmaxfeeBig;
    }

    public Integer getIsspecialdaycharge() {
        return isspecialdaycharge;
    }

    public void setIsspecialdaycharge(Integer isspecialdaycharge) {
        this.isspecialdaycharge = isspecialdaycharge;
    }

    public Integer getOneBillmethod() {
        return oneBillmethod;
    }

    public void setOneBillmethod(Integer oneBillmethod) {
        this.oneBillmethod = oneBillmethod;
    }

    public Integer getTwoBillmethod() {
        return twoBillmethod;
    }

    public void setTwoBillmethod(Integer twoBillmethod) {
        this.twoBillmethod = twoBillmethod;
    }

    public Integer getIsSmallbigcarSet() {
        return isSmallbigcarSet;
    }

    public void setIsSmallbigcarSet(Integer isSmallbigcarSet) {
        this.isSmallbigcarSet = isSmallbigcarSet;
    }

    public ChargeMethodConfig getFirstConfig() {
        return firstConfig;
    }

    public void setFirstConfig(ChargeMethodConfig firstConfig) {
        this.firstConfig = firstConfig;
    }

    public ChargeMethodConfig getTwoConfig() {
        return twoConfig;
    }

    public void setTwoConfig(ChargeMethodConfig twoConfig) {
        this.twoConfig = twoConfig;
    }
}
