package com.icetech.sdk.request;

import java.io.Serializable;
import java.util.List;

/**
 * Description 收费方式配置
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2022/7/22 17:54
 */
public class ChargeMethodConfig implements Serializable {

    /**
     * 是否开启每次收费开关 1是 2否  默认是1
     */
    private Integer isopenoncecharge;

    /**
     * 每次收费金额 元
     */
    private String oncechargefee;

    /**
     * 大型车每次收费金额 元
     */
    private String oncechargefeeBig;

    /**
     * 是否开启按分钟收费开关 1是 2否 默认否
     */
    private Integer isopenother2;

    /**
     * 多少分钟范围   分钟
     */
    private Integer timeFrame;

    /**
     * 多少分钟范围计费多少钱 元
     */
    private String timeFrameOncefee;

    /**
     * 大型车多少分钟范围计费多少钱 元
     */
    private String timeFrameOncefeeBig;

    /**
     * 超时多少分钟范围每次收费多少钱 元
     */
    private String otherTimeframeOncefee;

    /**
     * 大型车超时多少分钟范围每次收费多少钱 元
     */
    private String otherTimeframeOncefeeBig;

    /**
     * 是否有附加选择项 1是 2否 默认为2
     */
    private Integer isattachoption;

    /**
     * 附加选择超过分钟数  分钟
     */
    private Integer overTime;

    /**
     * 加收过夜费 元
     */
    private String addOvernightFee;

    /**
     * 大型车加收过夜费 元
     */
    private String addOvernightFeeBig;

    /**
     * 超出多少分钟配置是否起作用 1：是 2否 默认为2
     */
    private Integer isOverTimeSet;

    /**
     * 单位时间  分钟
     */
    private Integer feespantime;

    /**
     * 小型车单位金额，单位元
     */
    private String feespanrate;

    /**
     * 大型车单位金额 元
     */
    private String feespanrateBig;

    /**
     * 阶梯计费详情
     */
    private List<StepChargeDetails> stepChargeDetails;

    public Integer getIsopenoncecharge() {
        return isopenoncecharge;
    }

    public void setIsopenoncecharge(Integer isopenoncecharge) {
        this.isopenoncecharge = isopenoncecharge;
    }

    public String getOncechargefee() {
        return oncechargefee;
    }

    public void setOncechargefee(String oncechargefee) {
        this.oncechargefee = oncechargefee;
    }

    public String getOncechargefeeBig() {
        return oncechargefeeBig;
    }

    public void setOncechargefeeBig(String oncechargefeeBig) {
        this.oncechargefeeBig = oncechargefeeBig;
    }

    public Integer getIsopenother2() {
        return isopenother2;
    }

    public void setIsopenother2(Integer isopenother2) {
        this.isopenother2 = isopenother2;
    }

    public Integer getTimeFrame() {
        return timeFrame;
    }

    public void setTimeFrame(Integer timeFrame) {
        this.timeFrame = timeFrame;
    }

    public String getTimeFrameOncefee() {
        return timeFrameOncefee;
    }

    public void setTimeFrameOncefee(String timeFrameOncefee) {
        this.timeFrameOncefee = timeFrameOncefee;
    }

    public String getTimeFrameOncefeeBig() {
        return timeFrameOncefeeBig;
    }

    public void setTimeFrameOncefeeBig(String timeFrameOncefeeBig) {
        this.timeFrameOncefeeBig = timeFrameOncefeeBig;
    }

    public String getOtherTimeframeOncefee() {
        return otherTimeframeOncefee;
    }

    public void setOtherTimeframeOncefee(String otherTimeframeOncefee) {
        this.otherTimeframeOncefee = otherTimeframeOncefee;
    }

    public String getOtherTimeframeOncefeeBig() {
        return otherTimeframeOncefeeBig;
    }

    public void setOtherTimeframeOncefeeBig(String otherTimeframeOncefeeBig) {
        this.otherTimeframeOncefeeBig = otherTimeframeOncefeeBig;
    }

    public Integer getIsattachoption() {
        return isattachoption;
    }

    public void setIsattachoption(Integer isattachoption) {
        this.isattachoption = isattachoption;
    }

    public Integer getOverTime() {
        return overTime;
    }

    public void setOverTime(Integer overTime) {
        this.overTime = overTime;
    }

    public String getAddOvernightFee() {
        return addOvernightFee;
    }

    public void setAddOvernightFee(String addOvernightFee) {
        this.addOvernightFee = addOvernightFee;
    }

    public String getAddOvernightFeeBig() {
        return addOvernightFeeBig;
    }

    public void setAddOvernightFeeBig(String addOvernightFeeBig) {
        this.addOvernightFeeBig = addOvernightFeeBig;
    }

    public Integer getIsOverTimeSet() {
        return isOverTimeSet;
    }

    public void setIsOverTimeSet(Integer isOverTimeSet) {
        this.isOverTimeSet = isOverTimeSet;
    }

    public Integer getFeespantime() {
        return feespantime;
    }

    public void setFeespantime(Integer feespantime) {
        this.feespantime = feespantime;
    }

    public String getFeespanrate() {
        return feespanrate;
    }

    public void setFeespanrate(String feespanrate) {
        this.feespanrate = feespanrate;
    }

    public String getFeespanrateBig() {
        return feespanrateBig;
    }

    public void setFeespanrateBig(String feespanrateBig) {
        this.feespanrateBig = feespanrateBig;
    }

    public List<StepChargeDetails> getStepChargeDetails() {
        return stepChargeDetails;
    }

    public void setStepChargeDetails(List<StepChargeDetails> stepChargeDetails) {
        this.stepChargeDetails = stepChargeDetails;
    }

    public static class StepChargeDetails implements Serializable {

        /**
         * 计时开始时间 分钟
         */
        private Integer startTimeModule;

        /**
         * 计时结束时间 分钟
         */
        private Integer endTimeModule;

        /**
         * 单位时间  分钟
         */
        private Integer feespantime;

        /**
         * 小型车单位金额，单位元
         */
        private String feespanrate;

        /**
         * 大型车单位金额 元
         */
        private String feespanrateBig;

        public Integer getStartTimeModule() {
            return startTimeModule;
        }

        public void setStartTimeModule(Integer startTimeModule) {
            this.startTimeModule = startTimeModule;
        }

        public Integer getEndTimeModule() {
            return endTimeModule;
        }

        public void setEndTimeModule(Integer endTimeModule) {
            this.endTimeModule = endTimeModule;
        }

        public Integer getFeespantime() {
            return feespantime;
        }

        public void setFeespantime(Integer feespantime) {
            this.feespantime = feespantime;
        }

        public String getFeespanrate() {
            return feespanrate;
        }

        public void setFeespanrate(String feespanrate) {
            this.feespanrate = feespanrate;
        }

        public String getFeespanrateBig() {
            return feespanrateBig;
        }

        public void setFeespanrateBig(String feespanrateBig) {
            this.feespanrateBig = feespanrateBig;
        }
    }

}
