package com.icetech.sdk.common;

/**
 * @author wgy
 */
public class OpenConfig {
    public static DataNameBuilder DATA_NAME_BUILDER = new DefaultDataNameBuilder();

    /** 成功返回码值 */
    private String successCode = "10000";
    /** 默认版本号 */
    private String defaultVersion = "1.0";
    /** 字符编码 */
    private String charset = "UTF-8";
    /** 签名方式 */
    private String signType = "md5";
    /** 格式类型名称 */
    private String formatType = "json";
    /** 时间戳格式 */
    private String timestampPattern = "yyyy-MM-dd HH:mm:ss";

    /** 接口属性名 */
    private String methodName = "method";
    /** 版本号名称 */
    private String versionName = "version";
    /** 编码名称 */
    private String charsetName = "charset";
    /** appKey名称 */
    private String appKeyName = "app_id";
    /** 时间戳名称 */
    private String timestampName = "timestamp";
    /** 签名串名称 */
    private String signName = "sign";
    /** 签名类型名称 */
    private String signTypeName = "sign_type";
    /** 格式化名称 */
    private String formatName = "format";
    /** accessToken名称 */
    private String accessTokenName = "app_auth_token";
    /** 国际化语言 */
    private String locale = "zh-CN";
    /** 响应code名称 */
    private String responseCodeName = "code";
    /** 错误响应节点 */
    private String errorResponseName = "error_response";

    /** 请求超时时间 */
    private int connectTimeoutSeconds = 60;
    /** http读取超时时间 */
    private int readTimeoutSeconds = 60;
    /** http写超时时间 */
    private int writeTimeoutSeconds = 60;

    /**
     * 构建数据节点名称
     */
    private DataNameBuilder dataNameBuilder = DATA_NAME_BUILDER;
    

    public String getSuccessCode() {
        return successCode;
    }

    public void setSuccessCode(String successCode) {
        this.successCode = successCode;
    }

    public String getDefaultVersion() {
        return defaultVersion;
    }

    public void setDefaultVersion(String defaultVersion) {
        this.defaultVersion = defaultVersion;
    }

    public String getCharset() {
        return charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getSignType() {
        return signType;
    }

    public void setSignType(String signType) {
        this.signType = signType;
    }

    public String getFormatType() {
        return formatType;
    }

    public void setFormatType(String formatType) {
        this.formatType = formatType;
    }

    public String getTimestampPattern() {
        return timestampPattern;
    }

    public void setTimestampPattern(String timestampPattern) {
        this.timestampPattern = timestampPattern;
    }

    public String getMethodName() {
        return methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getVersionName() {
        return versionName;
    }

    public void setVersionName(String versionName) {
        this.versionName = versionName;
    }

    public String getCharsetName() {
        return charsetName;
    }

    public void setCharsetName(String charsetName) {
        this.charsetName = charsetName;
    }

    public String getAppKeyName() {
        return appKeyName;
    }

    public void setAppKeyName(String appKeyName) {
        this.appKeyName = appKeyName;
    }

    public String getTimestampName() {
        return timestampName;
    }

    public void setTimestampName(String timestampName) {
        this.timestampName = timestampName;
    }

    public String getSignName() {
        return signName;
    }

    public void setSignName(String signName) {
        this.signName = signName;
    }

    public String getSignTypeName() {
        return signTypeName;
    }

    public void setSignTypeName(String signTypeName) {
        this.signTypeName = signTypeName;
    }

    public String getFormatName() {
        return formatName;
    }

    public void setFormatName(String formatName) {
        this.formatName = formatName;
    }

    public String getAccessTokenName() {
        return accessTokenName;
    }

    public void setAccessTokenName(String accessTokenName) {
        this.accessTokenName = accessTokenName;
    }

    public String getLocale() {
        return locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public String getResponseCodeName() {
        return responseCodeName;
    }

    public void setResponseCodeName(String responseCodeName) {
        this.responseCodeName = responseCodeName;
    }

    public String getErrorResponseName() {
        return errorResponseName;
    }

    public void setErrorResponseName(String errorResponseName) {
        this.errorResponseName = errorResponseName;
    }

    public int getConnectTimeoutSeconds() {
        return connectTimeoutSeconds;
    }

    public void setConnectTimeoutSeconds(int connectTimeoutSeconds) {
        this.connectTimeoutSeconds = connectTimeoutSeconds;
    }

    public int getReadTimeoutSeconds() {
        return readTimeoutSeconds;
    }

    public void setReadTimeoutSeconds(int readTimeoutSeconds) {
        this.readTimeoutSeconds = readTimeoutSeconds;
    }

    public int getWriteTimeoutSeconds() {
        return writeTimeoutSeconds;
    }

    public void setWriteTimeoutSeconds(int writeTimeoutSeconds) {
        this.writeTimeoutSeconds = writeTimeoutSeconds;
    }

    public DataNameBuilder getDataNameBuilder() {
        return dataNameBuilder;
    }

    public void setDataNameBuilder(DataNameBuilder dataNameBuilder) {
        this.dataNameBuilder = dataNameBuilder;
    }
}
