package com.icetech.sdk.common;

import com.icetech.sdk.response.BaseResponse;

/**
 * @author wgy
 */
public enum IceSdkErrors {
    /**
     * 网络错误
     */
    HTTP_ERROR("836875001", "网络错误"),
    /**
     * 验证返回sign错误
     */
    CHECK_RESPONSE_SIGN_ERROR("836875002", "验证服务端sign出错")
    ;

    IceSdkErrors(String code, String msg) {
        this.code = code;
        this.msg = msg;
        this.subCode = code;
        this.subMsg = msg;
    }

    public BaseResponse.ErrorResponse getErrorResponse() {
        BaseResponse.ErrorResponse errorResponse = new BaseResponse.ErrorResponse();
        errorResponse.setCode(code);
        errorResponse.setSubCode(subCode);
        errorResponse.setSubMsg(subMsg);
        errorResponse.setMsg(msg);
        return errorResponse;
    }

    private String code;
    private String msg;
    private String subCode;
    private String subMsg;

    public String getCode() {
        return code;
    }

    public String getMsg() {
        return msg;
    }

    public String getSubCode() {
        return subCode;
    }

    public String getSubMsg() {
        return subMsg;
    }

}
