package com.icetech.sdk.client;

import com.alibaba.fastjson.JSON;
import com.icetech.sdk.common.*;
import com.icetech.sdk.response.BaseResponse;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;

/**
 * 负责请求操作
 *
 * @author wgy
 */
public class OpenRequest {

    private OpenHttp openHttp;

    public OpenRequest(OpenConfig openConfig) {
        this.openHttp = new OpenHttp(openConfig);
    }

    public String request(String url, RequestForm requestForm, Map<String, String> header) {
        try {
            Map<String, Object> form = requestForm.getForm();
            List<UploadFile> files = requestForm.getFiles();
            if (files != null && files.size() > 0) {
                return openHttp.requestFile(url, form, header, files);
            } else {
                RequestMethod requestMethod = requestForm.getRequestMethod();
                if (requestMethod == RequestMethod.GET) {
                    String query = this.buildGetQueryString(form, requestForm.getCharset());
                    if (query != null && query.length() > 0) {
                        url = url + "?" + query;
                    }
                    return openHttp.get(url, header);
                } else {
                    return openHttp.requestJson(url, JSON.toJSONString(form), header);
                }
            }
        } catch (IOException e) {
            return this.causeException(e);
        }
    }

    protected String buildGetQueryString(Map<String, Object> params, String charset) throws UnsupportedEncodingException {
        if (params == null || params.size() == 0) {
            return "";
        }
        StringBuilder query = new StringBuilder();
        int i = 0;
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            if (i++ > 0) {
                query.append("&");
            }
            query.append(name).append("=").append(URLEncoder.encode(value.toString(), charset));
        }
        return query.toString();
    }

    protected String causeException(Exception e) {
        BaseResponse baseResponse = new BaseResponse() {
        };
        BaseResponse.ErrorResponse result = IceSdkErrors.HTTP_ERROR.getErrorResponse();
        baseResponse.setErrorResponse(result);
        return JSON.toJSONString(baseResponse);
    }
}
