package com.icetech.base.request;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * Description ParkDeviceRequest
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2021/6/10 6:23 下午
 */
@Data
public class ParkDeviceRequest implements Serializable {

    /**
     * 设备序列号(模糊查询)
     */
    private String serialNumber;

    /**
     * 车场id
     */
    private Integer parkId;

    /**
     * 端云相机协议类型，1：WS，2：阿里IOT
     */
    private List<Integer> protocolTypes;

    /**
     * 设备状态,0初始1在线2离线3故障
     */
    private List<Integer> status;

    /**
     * 离线时长(单位分钟)
     */
    private Integer offlineDuration;

    /**
     * 设备类型 0：超级盒子 1：摄像头 2:道闸 3:显示屏 4:语音对讲机 5:智能机器人 6:监控相机 7:对讲立柱
     */
    private List<Integer> deviceTypes;

    /**
     *  sn 不为空， 默认1 不为空
     */
    private Integer nonSn = 1; 

    /**
     * 页码(默认：1)
     */
    private Integer pageNo = 1;

    /**
     * 页数(默认：10)
     */
    private Integer pageSize = 10;
}
