package com.icetech.base.api;

import com.icetech.common.domain.response.ObjectResponse;
import org.dom4j.DocumentException;

import java.util.HashMap;

/**
 * @author wanggang
 * @create 2022-03-02 15:22
 */
public interface IceVerifyCodeApi {

    /**
     * 通过手机号获取验证码
     *
     * @param phone 手机号
     * @param type  1:单纯获取验证码 2:忘记密码
     * @return
     * @throws DocumentException
     */
    ObjectResponse<String> getCode(String phone, String type) throws DocumentException;

    /**
     * 通过ticket进行校验验证码
     *
     * @param ticket
     * @param code
     * @return
     */
    ObjectResponse<String> verify(String ticket, String code);


    /**
     * 发送短信接口
     *
     * @param phone        手机号
     * @param templateCode 模板code
     * @param param        参数
     * @return
     * @throws DocumentException
     */
    ObjectResponse<String> sendMsg(String phone, String templateCode, HashMap<String, Object> param) throws DocumentException;
}
