package com.icetech.base.model;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * 路由配置
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @date 2021-12-08
 */
@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
public class IceRoute implements Serializable {

    private static final long serialVersionUID=1L;

    /**
     * 路由id
     */
    @TableId(value = "id", type = IdType.INPUT)
    private String id;

    private String serviceId;

    /**
     * 接口名
     */
    private String name;

    /**
     * 版本号
     */
    private String version;

    /**
     * 路由断言（SpringCloudGateway专用）
     */
    private String predicates;

    /**
     * 路由过滤器（SpringCloudGateway专用）
     */
    private String filters;

    /**
     * 路由规则转发的目标uri
     */
    private String uri;

    /**
     * uri后面跟的path
     */
    private String path;

    /**
     * 路由执行的顺序
     */
    private Integer orderIndex;

    /**
     * 是否忽略验证，业务参数验证除外
     */
    private Integer ignoreValidate;

    /**
     * 状态，0：待审核，1：启用，2：禁用
     */
    private Integer status;

    /**
     * 是否合并结果
     */
    private Integer mergeResult;

    /**
     * 是否需要授权才能访问
     */
    private Integer permission;

    /**
     * 是否为通知url
     */
    private Integer notifyUrl;

    /**
     * 是否需要token
     */
    private Integer needToken;

    @TableField(fill = FieldFill.INSERT)
    private Date createTime;

    @TableField(fill = FieldFill.UPDATE)
    private Date updateTime;


}
