package com.icetech.base.model;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * 应用信息表
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @date 2021-12-08
 */
@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
public class IceAppInfo implements Serializable {

    private static final long serialVersionUID=1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * appKey
     */
    private String appId;

    /**
     * 应用名称
     */
    private String appName;

    /**
     * 1:MD5
     */
    private Integer signType;

    /**
     * 密钥
     */
    private String secret;

    /**
     * 备注
     */
    private String remark;

    /**
     * ip 白名单, 空-不校验
     */
    private String ipList;

    /**
     * 行业
     */
    private String industry;

    /**
     * 消息推送url
     */
    private String pushUrl;

    /**
     * 用户id
     */
    private Integer userId;

    /**
     * 1启用，2禁用
     */
    private Integer status;

    @TableField(fill = FieldFill.INSERT)
    private Date createTime;

    @TableField(fill = FieldFill.UPDATE)
    private Date updateTime;


}
