package com.icetech.base.response;

import com.icetech.base.model.IcePark;
import lombok.Data;

import java.io.Serializable;

/**
 * 车场编码
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @date 2021-06-10
 */
@Data
public class ParkDto implements Serializable {
    
    /**
     * 车场id
     */
    private Integer parkId;
    /**
     * 车场编码
     */
    private String parkCode;
    /**
     * 车场编码
     */
    private String parkName;
    
    public static ParkDto todo(IcePark icePark) {
        ParkDto parkDto = new ParkDto();
        parkDto.setParkId(icePark.getId());
        parkDto.setParkCode(icePark.getParkcode());
        parkDto.setParkName(icePark.getParkName());
        return parkDto;
    }
}
