package com.icetech.base.model;

import com.baomidou.mybatisplus.annotation.IdType;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * 出入口通道表
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @date 2021-06-07
 */
@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
public class IceParkInoutdevice implements Serializable {

    private static final long serialVersionUID=1L;

    /**
     * id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 停车场ID
     */
    private Integer parkId;

    /**
     * 出入口编号
     */
    private String inandoutCode;

    /**
     * 第三方出入口编码
     */
    private String thirdInandoutCode;

    /**
     * 出入口名称
     */
    private String inandoutName;

    /**
     * 出入口类型，1入口 2出口
     */
    private Integer inandoutType;

    /**
     * 通道图片
     */
    private String image;

    /**
     * 状态 0正常 1冻结
     */
    private Integer status;

    /**
     * 添加时间
     */
    @TableField(fill = FieldFill.INSERT)
    private Date createTime;

    /**
     * 添加人
     */
    private String adder;

    /**
     * 更新时间
     */
    @TableField(fill = FieldFill.UPDATE)
    private Date updateTime;

    /**
     * 更新人
     */
    private String updateUser;

    /**
     * 是否允许临时车进出 0:不允许  1：允许 默认1
     */
    private Integer isAllowTempcarrun;

    /**
     * 是否允许无牌车扫码进出 0:不允许  1：允许 默认1
     */
    private Integer isAllowNocardrun;

    /**
     * 黄牌车是否允许进 0:不开启  1：开启 默认0
     */
    private Integer isAllowYellowcarrun;

    /**
     * 是否开启模糊识别 0:不开启  1：开启 默认0
     */
    private Integer isOpenVaguetype;

    /**
     * 缓存时效，单位秒，默认为600秒；
     */
    private Integer cacheExpires;

    /**
     * 模糊模式 0：去汉字 1：去汉字1位 2：去汉字2位
     */
    private Integer vaguetype;

    /**
     * 是否开启二维码扫码进出0：不允许，1：允许 默认0 此标识不再使用
     */
    private Integer isOpenQrcodetype;

    /**
     * 是否允许新能源车辆进出 0：不允许 1：允许 默认1
     */
    private Integer isAllowNewenergycarrun;

    /**
     * 是否允许预约车进出0：不允许，1：允许
     */
    private Integer isAllowVisitCar;

    /**
     * 是否允月卡车车进出0：不允许，1：允许
     */
    private Integer isAllowMonthCar;

    /**
     * 是否允许过期月卡车进出0：不允许，1：允许
     */
    private Integer isAllowOvertimeCar;

    /**
     * 过期天数
     */
    private Integer overTimeDay;

    /**
     * 过期卡是否按月卡处理0：否，1：是
     */
    private Integer overtimeMonthlyCard;

    /**
     * 是否允许黑名单车进出0：不允许，1：允许
     */
    private Integer isAllowBackCar;

    /**
     * 是否允许Vip车进出0：不允许，1：允许
     */
    private Integer isAllowVipCar;

    /**
     * 车场类型id，多个以逗号隔开
     */
    private String vipCarTypeId;

    /**
     * 是否允许多位多车月卡车进出1=是 0=否
     */
    private Integer isAllowAbcar;

    /**
     * 是否收费 1=是 0=否
     */
    private Integer isFee;

    /**
     * 是否是主通道 1=是 0=否
     */
    private Integer isMaster;

    /**
     * 区域id
     */
    private Integer regionId;

    /**
     * 是否允许蓝牌车进出 0:不允许  1：允许 默认1
     */
    private Integer isAllowBluerun;

    /**
     * 是否允许储值卡车进入 0:不允许  1：允许 默认1
     */
    private Integer isAllowStoredCar;


}
