package com.icetech.base.model;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * 停车场表
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @date 2021-06-07
 */
@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
public class IcePark implements Serializable {

    private static final long serialVersionUID=1L;

    /**
     * 主键自增长id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 停车场编号
     */
    @TableField("`parkcode`")
    private String parkCode;

    /**
     * 名称
     */
    private String parkName;

    /**
     * 所属机构
     */
    private Integer institutionId;

    /**
     * 所属省份
     */
    private Integer provinceId;

    /**
     * 所属城市
     */
    private Integer cityAreaId;

    /**
     * 所属区域
     */
    private Integer districtId;

    /**
     * 联系方式
     */
    private String phone;

    /**
     * 停车场地址
     */
    private String address;

    /**
     * 出口数量
     */
    private Integer totalExit;

    /**
     * 入口数量
     */
    private Integer totalEnter;

    /**
     * 泊位总数
     */
    private Integer totalPark;

    /**
     * 长租车位数
     */
    private Integer totalFixedspaces;

    /**
     * 车场类型（0:室内、1：室外、2：室内+室外、3：占道 默认：0
     */
    private Integer parkType;

    /**
     * 车场客户端类型（1车牌识别
     */
    private Integer parkClientType;

    /**
     * 场中场切换免费时长 分钟
     */
    private Integer switchFeeTime;

    /**
     * 运营状态（1正常、0暂停）
     */
    @TableField("`status`")
    private Integer status;

    /**
     * 资产类型(1产权、2管理权、3经营权默认0)
     */
    private Integer assetType;

    /**
     * 合作方式(1自营、2合作、3加盟默认0)
     */
    private Integer cooperateType;

    /**
     * 停车场属性 0：其他 1：商超 2：商务写字楼 3：公共场馆 4 星级酒店 5：住宅 6：医院 7：学校 8：交通枢纽 9：商业综合体 10产业园 11路侧
     */
    private Integer parkProperty;

    /**
     * 是否存在场中场(0否，1是默认0)
     */
    private Integer isInterior;

    /**
     * 纬度
     */
    private String lat;

    /**
     * 经度
     */
    private String lng;

    /**
     * 密钥
     */
    @TableField("`key`")
    private String key;

    /**
     * 添加时间
     */
    @TableField(fill = FieldFill.INSERT)
    private Date createTime;

    /**
     * 添加人
     */
    private String adder;

    /**
     * 更新时间
     */
    @TableField(fill = FieldFill.UPDATE)
    private Date updateTime;

    /**
     * 更新人
     */
    private String updateUser;

    /**
     * 车场营业执照
     */
    private String parkBusinessLicense;

    /**
     * 车场图片
     */
    private String parkImgs;

    /**
     * 紧急联系电话
     */
    private String telphone;

    public String getParkCode() {
        return parkCode;
    }

    public void setParkCode(String parkCode) {
        this.parkCode = parkCode;
    }

    public String getParkcode() {
        return getParkCode();
    }

    public void setParkcode(String parkcode) {
        setParkCode(parkcode);
    }
}
