package com.icetech.base.model;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * 错误消息
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @date 2021-10-25
 */
@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
public class IceErrorMsg implements Serializable {

    private static final long serialVersionUID=1L;

    /**
     * 主键
     */
    @TableId(value = "error_msg_id", type = IdType.AUTO)
    private Long errorMsgId;

    /**
     * 消息di
     */
    private String correlationId;

    /**
     * mq名字
     */
    private String mqName;

    /**
     * 交换机名称
     */
    private String exchange;

    /**
     * 路由
     */
    private String routing;

    /**
     * 消费队列
     */
    private String consumerQueue;

    /**
     * 类名
     */
    private String className;

    /**
     * 类型， 1： 发送异常，2：消费异常
     */
    private Integer type;

    /**
     * 发送异常类型， 1： ask exception, 2: returned exception
     */
    private Integer sendType;

    /**
     * 消息内容
     */
    private String msg;

    /**
     * 错误消息
     */
    private String errMsg;

    /**
     * 消息处理标示
     */
    private Integer flag;

    /**
     * 创建时间
     */
    @TableField(fill = FieldFill.INSERT)
    private Date createTime;

    /**
     * 修改时间
     */
    private Date lastModifyDate;


}
