package com.icetech.base.api;

import com.icetech.base.model.IceBaseUser;
import com.icetech.common.domain.response.ObjectResponse;

/**
 * @author wanggang
 * @create 2022-03-03 10:25
 */
public interface IceBaseUserApi {

    /**
     * 通过手机获取用户信息
     *
     * @param mobile
     * @return
     */
    ObjectResponse<IceBaseUser> getBaseUserByMobile(String mobile);

    /**
     * 通过用户id获取用户信息
     *
     * @param userId
     * @return
     */
    ObjectResponse<IceBaseUser> getBaseUserByUserId(Long userId);

    /**
     * 绑定用户手机号
     * @param accountId
     * @param ticket
     * @param code
     * @return
     */
    ObjectResponse<Long> bindUser(Long accountId, String ticket, String code);
}
