package com.icetech.base.response;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.icetech.base.model.IceParkDevice;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;

/**
 * 设备信息
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @date 2021-06-10
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class ParkDeviceResponse extends IceParkDevice implements Serializable {

    /**
     * 出入口编号
     */
    private String inandoutCode;
    /**
     * 所属出入口名称
     */
    private String inandoutName;
    /**
     * 车场名称
     */
    private String parkName;

    /**
     * 最后一次通讯时间
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endUpdatetime;

    /**
     * 上报或创建时间
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

}
