package com.icetech.base.model;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * 设备信息表
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @date 2021-06-07
 */
@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
public class IceParkDevice implements Serializable {

    private static final long serialVersionUID=1L;

    /**
     * id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 停车场ID
     */
    private Integer parkId;

    /**
     * 设备编号
     */
    private String deviceNo;

    /**
     * 第三方设备编码
     */
    private String thirdCode;

    /**
     * 设备类型 0：超级盒子 1：摄像头 2:道闸 3:显示屏 4:语音对讲机 5:智能机器人 6:监控相机 7:对讲立柱
     */
    private Integer type;

    /**
     * 出入口通道id(出入口表自增ID)
     */
    private Integer channelId;

    /**
     * 相机型号1：V82, 2：V83
     */
    private Integer modelType;

    /**
     * 相机序列号
     */
    private String serialNumber;

    /**
     * 端云相机协议版本号
     */
    private String protocolVer;

    /**
     * 端云相机协议类型，1：WS，2：阿里IOT
     */
    private Integer protocolType;

    /**
     * 设备型号
     */
    private String productModel;

    /**
     * 固件版本号
     */
    private String firmwareVersion;

    /**
     * 相机序列号图片
     */
    private String imageUrl;

    /**
     * 设备IP
     */
    private String ip;

    /**
     * 设备端口
     */
    private String port;

    /**
     * 通讯方式 1:4G 2:有线3:wifi 4:相机485透传
     */
    private Integer callMethods;

    /**
     * 设备状态,0初始1在线2离线3故障
     */
    private Integer status;

    /**
     * 删除标记，0：正常，1：删除
     */
    private Integer delFlag;

    /**
     * 上报或创建时间
     */
    @TableField(fill = FieldFill.INSERT)
    private Date createTime;

    /**
     * 更新时间
     */
    @TableField(fill = FieldFill.UPDATE)
    private Date updateTime;

    /**
     * 添加人
     */
    private String adder;

    /**
     * 最后一次通讯时间
     */
    private Date endUpdatetime;

    /**
     * 通讯类型（0: TCP/IP，1：串口）
     */
    private Integer linetype;

    /**
     * 串口地址
     */
    private Integer serialaddr;

    /**
     * 波特率（0：1200，1：2400，2：4800，3：9600，4：19200，5：38400，6：115200，默认2400）; 
     */
    private Integer baudrate;

    /**
     * 监控相机视频地址
     */
    private String videoUrl;

    /**
     * 是否双摄相机，1：是，0：否
     */
    private Boolean isDualcamera;

    /**
     * 是否主相机，0：否，1：是，一个通道只会有一个主相机
     */
    private Boolean isMaster;

    private String verCode;

    private Integer ezopenId;
    /**
     * 无线网络运营商，1:移动，2:电信，3：联通，99：未知
     */
    private Integer wirelessCarrier;
    /**
     * 第几代无线网，例：5G、4G、3G、2G
     */
    private String network;

    /**
     * 通讯协议是否自动切换 0:否  1：是 默认1
     */
    private Integer isAutoswitchCheck;

    /**
     * 语音对讲设备厂商类型 1：云翌  2：笛虎
     */
    private Integer voicevendorType;


}
