package com.icetech.base.model;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * 车场心跳断开记录表
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @date 2021-06-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
public class IceHeartbeatOffline implements Serializable {

    private static final long serialVersionUID=1L;

    /**
     * 自增长ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 停车场ID
     */
    private Integer parkId;

    /**
     * 设备编号
     */
    private String deviceNo;

    /**
     * 最后连接时间
     */
    private Integer lastConnectionTime;

    /**
     * 重新连接时间
     */
    private Integer reconnectTime;

    /**
     * 断开总时长（秒）
     */
    private Integer offTime;

    /**
     * 创建时间
     */
    @TableField(fill = FieldFill.INSERT)
    private Date createTime;


}
