package com.icetech.base.domain;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * Description DeviceUpDownMsg
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2021/5/12 3:57 下午
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class DeviceStatusMsg implements Serializable {

    /**
     * 模块
     */
    private String module;
    
    /**
     * 设备号
     */
    private String sn;

    /**
     * 设备状态，在线2离线3故障
     */
    private Integer status;

    /**
     * 登录ip
     */
    private String ip;

    /**
     * 时间
     */
    private Date dateTime;

    /**
     * 接入协议类型，1：WS，2：IOT
     */
    private Integer protocolType;
}
