package com.icetech.base.constants;

/**
 * Description mq 常量配置
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2021/4/30 3:27 PM
 */
public class MqConstants {

    /**
     * 交换机
     */
    public static class Exchange {

        /**
         * 设备相关交换机
         */
        public static String ICE_DEVICE_EXCHANGE = ".ice.device.exchange";

        /**
         *
         * @param module 模块
         * @return
         */
        public static String getIceDeviceExchange(String module) {
            return module + ICE_DEVICE_EXCHANGE;
        }

        /**
         * 返回交换机
         * @param module    功能模块
         * @return
         */
        public static String getExchange(String module) {
            return module + ".exchange";
        }
    }

    /**
     * 路由
     */
    public static class Routing {

        /**
         *  设备状态路由
         */
        public static final String DEVICE_STATUS_ROUTING = "device.status.routing";

        /**
         * 路由信息
         * @param module    功能模块
         * @param cmd       cmd
         * @return routing
         */
        public static String getRouting(String module, String cmd) {
            return module + "." + cmd + ".routing";
        }
    }

    /**
     * 路由
     */
    public static class Queues {
        
        
    }
}
